/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.lib.ConfigProcessor;

public final class ModOptions {
    public static final String CATEGORY_LOGGING_CONTROL = "logging";
    public static final String CONFIG_ENABLE_DEBUG_LOGGING = "Enable Debug Logging";
    public static final String CONFIG_ENABLE_ONLINE_VERSION_CHECK = "Enable Online Version Check";

    private ModOptions() {
    }

    public static void load(Configuration config) {
        for (String cat : config.getCategoryNames()) {
            ModOptions.scrubCategory(config.getCategory(cat));
        }
    }

    private static void scrubCategory(ConfigCategory category) {
        ArrayList killList = new ArrayList();
        for (Map.Entry entry : category.entrySet()) {
            if (!StringUtils.isEmpty((CharSequence)((Property)entry.getValue()).getComment())) continue;
            killList.add(entry.getKey());
        }
        for (String kill : killList) {
            category.remove((Object)kill);
        }
    }

    @ConfigProcessor.Category(value="logging")
    @ConfigProcessor.LangKey(value="presets.cfg.logging.cat.Logging")
    @ConfigProcessor.Comment(value="Defines how Presets! logging will behave")
    public static class logging {
        public static final List<String> SORT = Arrays.asList("Enable Online Version Check", "Enable Debug Logging");
        @ConfigProcessor.Option(value="Enable Debug Logging")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="presets.cfg.logging.EnableDebug")
        @ConfigProcessor.Comment(value="Enables/disables debug logging of the mod")
        @ConfigProcessor.RestartRequired
        public static boolean enableDebugLogging = false;
        @ConfigProcessor.Option(value="Enable Online Version Check")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="presets.cfg.logging.VersionCheck")
        @ConfigProcessor.Comment(value="Enables/disables display of version check information")
        @ConfigProcessor.RestartRequired
        public static boolean enableVersionChecking = true;
    }
}

