/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.server.services;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.data.DimensionEffectData;
import org.blockartistry.DynSurround.network.Network;
import org.blockartistry.DynSurround.network.PacketThunder;
import org.blockartistry.DynSurround.network.PacketWeatherUpdate;
import org.blockartistry.DynSurround.registry.DimensionInfo;
import org.blockartistry.DynSurround.server.services.ServerRegistry;
import org.blockartistry.lib.PlayerUtils;
import org.blockartistry.lib.random.XorShiftRandom;

public class WeatherGenerator {
    protected final Random RANDOM = XorShiftRandom.current();
    protected final DimensionInfo dimension;
    protected final World world;
    protected final WorldInfo info;
    protected final DimensionEffectData data;

    public WeatherGenerator(@Nonnull World world) {
        this.world = world;
        this.info = world.func_72912_H();
        this.data = DimensionEffectData.get(world);
        this.dimension = ServerRegistry.DIMENSION.getData(world);
    }

    @Nonnull
    public String name() {
        return "STANDARD";
    }

    protected int nextRainInterval(boolean isRaining) {
        int base = isRaining ? ModOptions.rain.rainActiveTimeConst : ModOptions.rain.rainInactiveTimeConst;
        return base + this.RANDOM.nextInt(isRaining ? ModOptions.rain.rainActiveTimeVariable : ModOptions.rain.rainInactiveTimeVariable);
    }

    protected int nextThunderInterval(boolean isThundering) {
        int base = isThundering ? ModOptions.rain.stormActiveTimeConst : ModOptions.rain.stormInactiveTimeConst;
        return base + this.RANDOM.nextInt(isThundering ? ModOptions.rain.stormActiveTimeVariable : ModOptions.rain.stormInactiveTimeVariable);
    }

    protected int nextThunderEvent(float rainIntensity) {
        float scale = 2.0f - rainIntensity;
        return this.RANDOM.nextInt((int)(450.0f * scale)) + 300;
    }

    protected boolean doFlash(float rainIntensity) {
        int randee = (int)(rainIntensity * 100.0f);
        return this.RANDOM.nextInt(150) <= randee;
    }

    protected void preProcess() {
    }

    protected void doRain() {
        int rain2 = this.info.func_76083_p();
        if (rain2 == 2) {
            this.info.func_76084_b(!this.info.func_76059_o());
            this.info.func_76080_g(this.nextRainInterval(this.info.func_76059_o()));
        }
        if (this.info.func_76059_o()) {
            if (this.data.getRainIntensity() == 0.0f) {
                this.data.randomizeRain();
                this.info.func_76080_g(this.nextRainInterval(true));
                DSurround.log().debug("dim %d rain intensity set to %f, duration %d ticks", this.data.getDimensionId(), Float.valueOf(this.data.getRainIntensity()), this.info.func_76083_p());
            }
            this.data.setCurrentRainIntensity(this.world.func_72867_j(1.0f));
        } else if (this.world.func_72867_j(1.0f) > 0.0f) {
            this.data.setCurrentRainIntensity(this.world.func_72867_j(1.0f));
        } else if (this.data.getCurrentRainIntensity() > 0.0f) {
            this.data.setRainIntensity(0.0f);
            this.data.setCurrentRainIntensity(0.0f);
            this.info.func_76080_g(this.nextRainInterval(false));
            DSurround.log().debug("dim %d rain has stopped, next rain %d ticks", this.data.getDimensionId(), this.info.func_76083_p());
        } else if (this.data.getRainIntensity() > 0.0f) {
            this.data.setRainIntensity(0.0f);
        }
    }

    protected void doThunder() {
        int thunder = this.info.func_76071_n();
        if (thunder == 2) {
            this.info.func_76069_a(!this.info.func_76061_m());
            this.info.func_76090_f(this.nextThunderInterval(this.info.func_76061_m()));
        }
    }

    protected void doAmbientThunder() {
        if (!ModOptions.rain.allowBackgroundThunder) {
            return;
        }
        float intensity = this.data.getCurrentRainIntensity();
        if (this.info.func_76061_m() && intensity >= ModOptions.rain.stormThunderThreshold) {
            int time = this.data.getThunderTimer() - 1;
            if (time <= 0) {
                if (time == 0) {
                    EntityPlayer player2 = PlayerUtils.getRandomPlayer(this.world);
                    float theY = this.dimension.getSkyHeight();
                    if (player2 != null) {
                        PacketThunder packet = new PacketThunder(this.data.getDimensionId(), this.doFlash(intensity), new BlockPos(player2.field_70165_t, (double)theY, player2.field_70161_v));
                        Network.sendToDimension(this.data.getDimensionId(), packet);
                    }
                }
                time = this.nextThunderEvent(intensity);
            }
            this.data.setThunderTimer(time);
        } else {
            this.data.setThunderTimer(0);
        }
    }

    protected void postProcess() {
    }

    public final void update() {
        this.process();
        this.sendUpdate();
    }

    protected void process() {
        this.preProcess();
        this.doRain();
        this.doThunder();
        this.doAmbientThunder();
        this.postProcess();
    }

    protected void sendUpdate() {
        if (this.world.field_73010_i.size() > 0) {
            PacketWeatherUpdate packet = new PacketWeatherUpdate(this.data.getDimensionId(), this.data.getCurrentRainIntensity(), this.data.getRainIntensity(), this.info.func_76083_p(), this.world.func_72819_i(1.0f), this.info.func_76071_n(), this.data.getThunderTimer());
            Network.sendToDimension(this.data.getDimensionId(), packet);
        }
    }
}

