/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.DynSurround.data.xface.ItemConfig;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.registry.ArmorClass;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.lib.ItemStackUtil;
import org.blockartistry.lib.MCHelper;
import org.blockartistry.lib.collections.IdentityHashSet;

@SideOnly(value=Side.CLIENT)
public final class ItemRegistry
extends Registry {
    private static final int SET_CAPACITY = 64;
    private static final int MAP_CAPACITY = 256;
    private Set<Class<?>> swordItems = new IdentityHashSet(64);
    private Set<Class<?>> axeItems = new IdentityHashSet(64);
    private Set<Class<?>> bowItems = new IdentityHashSet(64);
    private Set<Class<?>> toolItems = new IdentityHashSet(64);
    private Set<Class<?>> shieldItems = new IdentityHashSet(64);
    private Set<Class<?>> crystalItems = new IdentityHashSet(64);
    private Set<Class<?>> heavyItems = new IdentityHashSet(64);
    private Set<Class<?>> mediumItems = new IdentityHashSet(64);
    private Set<Class<?>> lightItems = new IdentityHashSet(64);
    private final Map<Item, ItemType> items = new IdentityHashMap<Item, ItemType>(256);
    private final Map<Item, ArmorClass> armorMap = new IdentityHashMap<Item, ArmorClass>(64);
    private final Map<Item, SoundEffect> swings = new IdentityHashMap<Item, SoundEffect>(256);
    private final Map<Item, SoundEffect> uses = new IdentityHashMap<Item, SoundEffect>(256);
    private final Map<Item, SoundEffect> equips = new IdentityHashMap<Item, SoundEffect>(256);

    public ItemRegistry(@Nonnull Side side) {
        super(side);
    }

    @Override
    public void init() {
        this.swordItems = new IdentityHashSet(64);
        this.axeItems = new IdentityHashSet(64);
        this.bowItems = new IdentityHashSet(64);
        this.toolItems = new IdentityHashSet(64);
        this.shieldItems = new IdentityHashSet(64);
        this.crystalItems = new IdentityHashSet(64);
        this.heavyItems = new IdentityHashSet(64);
        this.mediumItems = new IdentityHashSet(64);
        this.lightItems = new IdentityHashSet(64);
        this.items.clear();
        this.armorMap.clear();
        this.swings.clear();
        this.uses.clear();
        this.equips.clear();
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
        ItemConfig config = cfg.itemConfig;
        this.process(config.axeSound, this.axeItems, ItemType.AXE, null);
        this.process(config.bowSound, this.bowItems, ItemType.BOW, null);
        this.process(config.swordSound, this.swordItems, ItemType.SWORD, null);
        this.process(config.toolSound, this.toolItems, ItemType.TOOL, null);
        this.process(config.shieldSound, this.shieldItems, ItemType.SHIELD, null);
        this.process(config.crystalArmor, this.crystalItems, ItemType.ARMOR, ArmorClass.CRYSTAL);
        this.process(config.heavyArmor, this.heavyItems, ItemType.ARMOR, ArmorClass.HEAVY);
        this.process(config.mediumArmor, this.mediumItems, ItemType.ARMOR, ArmorClass.MEDIUM);
        this.process(config.lightArmor, this.lightItems, ItemType.ARMOR, ArmorClass.LIGHT);
    }

    @Override
    public void initComplete() {
        for (Item item : Item.field_150901_e) {
            ItemType t;
            if (!this.items.containsKey(item)) {
                if (this.doesBelong(this.swordItems, item)) {
                    this.items.put(item, ItemType.SWORD);
                } else if (this.doesBelong(this.axeItems, item)) {
                    this.items.put(item, ItemType.AXE);
                } else if (this.doesBelong(this.toolItems, item)) {
                    this.items.put(item, ItemType.TOOL);
                } else if (this.doesBelong(this.shieldItems, item)) {
                    this.items.put(item, ItemType.SHIELD);
                } else if (this.doesBelong(this.bowItems, item)) {
                    this.items.put(item, ItemType.BOW);
                } else if (this.doesBelong(this.crystalItems, item)) {
                    this.items.put(item, ItemType.ARMOR);
                    this.armorMap.put(item, ArmorClass.CRYSTAL);
                } else if (this.doesBelong(this.heavyItems, item)) {
                    this.items.put(item, ItemType.ARMOR);
                    this.armorMap.put(item, ArmorClass.HEAVY);
                } else if (this.doesBelong(this.mediumItems, item)) {
                    this.items.put(item, ItemType.ARMOR);
                    this.armorMap.put(item, ArmorClass.MEDIUM);
                } else if (this.doesBelong(this.lightItems, item)) {
                    this.items.put(item, ItemType.ARMOR);
                    this.armorMap.put(item, ArmorClass.LIGHT);
                } else if (item instanceof ItemFood) {
                    this.items.put(item, ItemType.FOOD);
                }
            }
            if ((t = this.items.get(item)) == null) continue;
            SoundEffect se = this.getSwingSound(item, t);
            if (se != null) {
                this.swings.put(item, se);
            }
            if ((se = this.getUseSound(item, t)) != null) {
                this.uses.put(item, se);
            }
            if ((se = this.getEquipSound(item, t)) == null) continue;
            this.equips.put(item, se);
        }
        this.swordItems = null;
        this.axeItems = null;
        this.bowItems = null;
        this.toolItems = null;
        this.shieldItems = null;
        this.crystalItems = null;
        this.heavyItems = null;
        this.mediumItems = null;
        this.lightItems = null;
    }

    @Override
    public void fini() {
    }

    private boolean doesBelong(@Nonnull Set<Class<?>> itemSet, @Nonnull Item item) {
        Class<?> itemClass = item.getClass();
        if (itemSet.contains(itemClass)) {
            return true;
        }
        for (Class<?> clazz : itemSet) {
            if (!clazz.isAssignableFrom(itemClass)) continue;
            itemSet.add(itemClass);
            return true;
        }
        return false;
    }

    private void process(@Nonnull List<String> items, @Nonnull Set<Class<?>> theList, @Nonnull ItemType it, @Nullable ArmorClass armor) {
        for (String c : items) {
            Item item;
            boolean likeMatch = c.startsWith("@") || !c.contains(":");
            Item item2 = item = c.contains(":") ? MCHelper.getItemByName(c) : null;
            if (!likeMatch) {
                if (item != null) {
                    this.items.put(item, it);
                    if (armor == null) continue;
                    this.armorMap.put(item, armor);
                    continue;
                }
                DSurround.log().warn("Cannot locate item [%s] for ItemRegistry", c);
                continue;
            }
            try {
                Class<?> clazz = item == null ? Class.forName(c, false, ItemRegistry.class.getClassLoader()) : item.getClass();
                theList.add(clazz);
            }
            catch (ClassNotFoundException e) {
                DSurround.log().warn("Cannot locate class '%s' for ItemRegistry", c);
            }
        }
    }

    protected ArmorClass getArmorClass(@Nonnull Item item) {
        ArmorClass result = this.armorMap.get(item);
        return result != null ? result : ArmorClass.NONE;
    }

    protected SoundEffect getSwingSound(@Nonnull Item item, @Nonnull ItemType t) {
        SoundEffect sound2;
        block0 : switch (t) {
            case SWORD: {
                sound2 = Sounds.SWORD_SWING;
                break;
            }
            case AXE: {
                sound2 = Sounds.AXE_SWING;
                break;
            }
            case BOW: 
            case TOOL: 
            case SHIELD: {
                sound2 = Sounds.TOOL_SWING;
                break;
            }
            case ARMOR: {
                ArmorClass armor = this.getArmorClass(item);
                switch (armor) {
                    case LIGHT: {
                        sound2 = Sounds.LIGHT_ARMOR_EQUIP;
                        break block0;
                    }
                    case MEDIUM: {
                        sound2 = Sounds.MEDIUM_ARMOR_EQUIP;
                        break block0;
                    }
                    case HEAVY: {
                        sound2 = Sounds.HEAVY_ARMOR_EQUIP;
                        break block0;
                    }
                    case CRYSTAL: {
                        sound2 = Sounds.CRYSTAL_ARMOR_EQUIP;
                        break block0;
                    }
                }
                sound2 = null;
                break;
            }
            default: {
                sound2 = null;
            }
        }
        return sound2;
    }

    protected SoundEffect getUseSound(@Nonnull Item item, @Nonnull ItemType t) {
        SoundEffect sound2;
        block0 : switch (t) {
            case BOW: {
                sound2 = Sounds.BOW_PULL;
                break;
            }
            case SHIELD: {
                sound2 = Sounds.SHIELD_USE;
                break;
            }
            case ARMOR: {
                ArmorClass armor = this.getArmorClass(item);
                switch (armor) {
                    case LIGHT: {
                        sound2 = Sounds.LIGHT_ARMOR_EQUIP;
                        break block0;
                    }
                    case MEDIUM: {
                        sound2 = Sounds.MEDIUM_ARMOR_EQUIP;
                        break block0;
                    }
                    case HEAVY: {
                        sound2 = Sounds.HEAVY_ARMOR_EQUIP;
                        break block0;
                    }
                    case CRYSTAL: {
                        sound2 = Sounds.CRYSTAL_ARMOR_EQUIP;
                        break block0;
                    }
                }
                sound2 = null;
                break;
            }
            default: {
                sound2 = null;
            }
        }
        return sound2;
    }

    protected SoundEffect getEquipSound(@Nonnull Item item, @Nonnull ItemType t) {
        SoundEffect sound2;
        block0 : switch (t) {
            case FOOD: {
                sound2 = Sounds.FOOD_EQUIP;
                break;
            }
            case SWORD: {
                sound2 = ModOptions.sound.swordEquipAsTool ? Sounds.TOOL_EQUIP : Sounds.SWORD_EQUIP;
                break;
            }
            case AXE: {
                sound2 = Sounds.AXE_EQUIP;
                break;
            }
            case TOOL: {
                sound2 = Sounds.TOOL_EQUIP;
                break;
            }
            case BOW: {
                sound2 = Sounds.BOW_EQUIP;
                break;
            }
            case SHIELD: {
                sound2 = Sounds.SHIELD_EQUIP;
                break;
            }
            case ARMOR: {
                ArmorClass armor = this.getArmorClass(item);
                switch (armor) {
                    case LIGHT: {
                        sound2 = Sounds.LIGHT_ARMOR_EQUIP;
                        break block0;
                    }
                    case MEDIUM: {
                        sound2 = Sounds.MEDIUM_ARMOR_EQUIP;
                        break block0;
                    }
                    case HEAVY: {
                        sound2 = Sounds.HEAVY_ARMOR_EQUIP;
                        break block0;
                    }
                    case CRYSTAL: {
                        sound2 = Sounds.CRYSTAL_ARMOR_EQUIP;
                        break block0;
                    }
                }
                sound2 = null;
                break;
            }
            default: {
                sound2 = null;
            }
        }
        return sound2;
    }

    @Nullable
    public ItemType getItemType(@Nonnull ItemStack stack) {
        return ItemStackUtil.isValidItemStack(stack) ? this.items.get(stack.func_77973_b()) : null;
    }

    public boolean isBow(@Nonnull ItemStack stack) {
        return this.getItemType(stack) == ItemType.BOW;
    }

    public boolean isShield(@Nonnull ItemStack stack) {
        return this.getItemType(stack) == ItemType.SHIELD;
    }

    @Nonnull
    public ArmorClass getArmorClass(@Nonnull ItemStack stack) {
        return ItemStackUtil.isValidItemStack(stack) ? this.getArmorClass(stack.func_77973_b()) : ArmorClass.NONE;
    }

    @Nullable
    public SoundEffect getSwingSound(@Nonnull ItemStack stack) {
        return ItemStackUtil.isValidItemStack(stack) ? this.swings.get(stack.func_77973_b()) : null;
    }

    @Nullable
    public SoundEffect getUseSound(@Nonnull ItemStack stack) {
        return ItemStackUtil.isValidItemStack(stack) ? this.uses.get(stack.func_77973_b()) : null;
    }

    @Nullable
    public SoundEffect getEquipSound(@Nonnull ItemStack stack) {
        if (ItemStackUtil.isValidItemStack(stack)) {
            SoundEffect result = this.equips.get(stack.func_77973_b());
            return result != null ? result : Sounds.UTILITY_EQUIP;
        }
        return null;
    }

    private static enum ItemType {
        SWORD,
        AXE,
        BOW,
        TOOL,
        SHIELD,
        ARMOR,
        FOOD;

    }
}

