/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.data.xface.EntityConfig;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.DynSurround.registry.ThemeInfo;
import org.blockartistry.DynSurround.registry.themes.GloamwoodTheme;

@SideOnly(value=Side.CLIENT)
public class EffectRegistry
extends Registry {
    public static final EntityEffectInfo DEFAULT = new EntityEffectInfo();
    public static final ResourceLocation DEFAULT_THEME = new ResourceLocation("dsurround", "default");
    private static final ThemeInfo DEFAULT_THEME_INFO = new ThemeInfo();
    protected final Map<Class<? extends Entity>, EntityEffectInfo> effects = new IdentityHashMap<Class<? extends Entity>, EntityEffectInfo>();
    protected EntityEffectInfo playerEffects = DEFAULT;
    protected final Map<ResourceLocation, ThemeInfo> themes = new HashMap<ResourceLocation, ThemeInfo>();
    protected ThemeInfo activeTheme = DEFAULT_THEME_INFO;

    public EffectRegistry(@Nonnull Side side) {
        super(side);
    }

    @Override
    public void init() {
        this.playerEffects = DEFAULT;
        this.effects.clear();
        this.themes.clear();
        this.activeTheme = DEFAULT_THEME_INFO;
        this.themes.put(DEFAULT_THEME, DEFAULT_THEME_INFO);
        this.themes.put(new ResourceLocation("dsurround", "gloamwood"), new GloamwoodTheme());
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
        for (Map.Entry<String, EntityConfig> e : cfg.entities.entrySet()) {
            String entityName = e.getKey();
            EntityConfig entityEffects = e.getValue();
            if ("minecraft:player".equals(entityName)) {
                this.playerEffects = new EntityEffectInfo(entityEffects);
                continue;
            }
            int id = EntityList.func_180122_a((String)entityName);
            Class clazz = EntityList.func_90035_a((int)id);
            if (clazz != null) {
                this.effects.put(clazz, new EntityEffectInfo(entityEffects));
                continue;
            }
            DSurround.log().warn("Unrecognized resource name for entity: %s", entityName);
        }
    }

    @Override
    public void initComplete() {
        block0: for (String string : EntityList.func_180124_b()) {
            int id = EntityList.func_180122_a((String)string);
            Class clazz = EntityList.func_90035_a((int)id);
            if (clazz != null) {
                if (this.effects.containsKey(clazz)) continue;
                for (Map.Entry<Class<? extends Entity>, EntityEffectInfo> e : this.effects.entrySet()) {
                    if (!e.getKey().isAssignableFrom(clazz)) continue;
                    this.effects.put(clazz, e.getValue());
                    continue block0;
                }
                continue;
            }
            DSurround.log().debug("Forge reported entity %s but not found in it's own registry!", string.toString());
        }
        DSurround.log().debug("Entity Effect Entries", new Object[0]);
        DSurround.log().debug("=====================", new Object[0]);
        for (Map.Entry entry : this.effects.entrySet()) {
            String keyName = EntityList.func_188430_a((Class)((Class)entry.getKey()));
            if (keyName == null) {
                keyName = "No ID Found";
            }
            DSurround.log().debug("%s = %s (%s)", keyName, ((EntityEffectInfo)entry.getValue()).toString(), ((Class)entry.getKey()).getName());
        }
    }

    @Override
    public void fini() {
    }

    @Nonnull
    public EntityEffectInfo getEffects(@Nonnull Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.playerEffects;
        }
        return this.effects.getOrDefault(entity.getClass(), DEFAULT);
    }

    @Nonnull
    public ThemeInfo setTheme(@Nonnull ResourceLocation theme) {
        this.activeTheme = this.themes.getOrDefault(theme, DEFAULT_THEME_INFO);
        return this.activeTheme;
    }

    @Nonnull
    public ThemeInfo getTheme() {
        return this.activeTheme;
    }
}

