/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.lib.BlockNameUtil;
import org.blockartistry.lib.MCHelper;

@SideOnly(value=Side.CLIENT)
public class BlockInfo {
    public static final int GENERIC = -1;
    public static final int NO_SUBTYPE = -100;
    public static final BlockInfo AIR = new BlockInfo(Blocks.field_150350_a);
    protected Block block;
    protected int meta;
    protected int specialMeta;
    private static final int TERM = 769;

    public BlockInfo(@Nonnull Block block2, int meta) {
        this.block = block2;
        this.meta = meta;
        this.specialMeta = -100;
    }

    public BlockInfo(@Nonnull Block block2) {
        this(block2, -100);
    }

    @Nonnull
    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    @Nullable
    public List<IBlockState> asBlockStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        ImmutableList valid = this.block.func_176194_O().func_177619_a();
        if (valid != null) {
            for (IBlockState bs : valid) {
                if (this.block.func_176201_c(bs) != this.meta) continue;
                states.add(bs);
            }
        }
        return states;
    }

    public int getSpecialMeta() {
        return this.specialMeta;
    }

    public boolean isGeneric() {
        return this.meta == -1;
    }

    public boolean hasSubTypes() {
        return this.meta != -100;
    }

    public boolean hasSpecialMeta() {
        return this.specialMeta != -100;
    }

    public int hashCode() {
        return this.block.hashCode() ^ this.meta * 769;
    }

    public boolean equals(Object obj) {
        return this.block == ((BlockInfo)obj).block && this.meta == ((BlockInfo)obj).meta;
    }

    @Nullable
    public static BlockInfo create(@Nonnull String blockId) {
        String workingName = blockId;
        int subType = -100;
        BlockNameUtil.NameResult result = BlockNameUtil.parseBlockName(blockId);
        if (result != null) {
            workingName = result.getBlockName();
            subType = result.isGeneric() ? -1 : (result.noMetadataSpecified() ? -100 : result.getMetadata());
        } else {
            DSurround.log().warn("Unkown block id [%s]", blockId);
        }
        Block block2 = MCHelper.getBlockByName(workingName);
        if (subType == -100 && MCHelper.hasVariants(block2)) {
            subType = -1;
        }
        return block2 != null ? new BlockInfo(block2, subType) : null;
    }

    public String toString() {
        if (this.block == null) {
            return "UNKNOWN";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(MCHelper.nameOf(this.block));
        if (this.isGeneric()) {
            builder.append(":*");
        } else if (this.hasSubTypes()) {
            builder.append(':').append(this.meta);
        } else if (this.hasSpecialMeta()) {
            builder.append('[').append(this.specialMeta).append(']');
        }
        return builder.toString();
    }

    public static class BlockInfoMutable
    extends BlockInfo {
        protected IBlockState lastState;
        protected int originalMeta;

        public BlockInfoMutable() {
            super(null);
            this.originalMeta = this.meta;
        }

        public BlockInfoMutable set(@Nonnull IBlockState state) {
            if (this.lastState == state) {
                this.meta = this.originalMeta;
            } else {
                this.configure(state);
                this.originalMeta = this.meta;
            }
            return this;
        }

        public BlockInfoMutable set(@Nonnull BlockInfo info) {
            this.block = info.block;
            this.meta = info.meta;
            this.specialMeta = info.specialMeta;
            this.originalMeta = this.meta;
            return this;
        }

        public BlockInfoMutable asGeneric() {
            this.meta = -1;
            return this;
        }

        public BlockInfoMutable asSpecial() {
            this.meta = this.specialMeta;
            return this;
        }

        protected void configure(@Nonnull IBlockState state) {
            this.block = state.func_177230_c();
            if (this.block == Blocks.field_150350_a) {
                this.meta = -100;
                this.specialMeta = -100;
            } else {
                this.meta = MCHelper.hasVariants(this.block) ? state.func_177230_c().func_176201_c(state) : -100;
                this.specialMeta = MCHelper.hasSpecialMeta(this.block) ? state.func_177230_c().func_176201_c(state) : -100;
            }
        }
    }
}

