/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.data.xface.BiomeConfig;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.DynSurround.registry.BiomeHandler;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.DynSurround.registry.BiomeMatcher;
import org.blockartistry.DynSurround.registry.DimensionInfo;
import org.blockartistry.DynSurround.registry.FakeBiome;
import org.blockartistry.DynSurround.registry.IBiome;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.DynSurround.registry.WTFFakeBiome;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class BiomeRegistry
extends Registry {
    private static final int INSIDE_Y_ADJUST = 3;
    public static final FakeBiome UNDERGROUND = new FakeBiome("Underground");
    public static final FakeBiome PLAYER = new FakeBiome("Player");
    public static final FakeBiome UNDERWATER = new FakeBiome("Underwater");
    public static final FakeBiome UNDEROCEAN = new FakeBiome("UnderOCN");
    public static final FakeBiome UNDERDEEPOCEAN = new FakeBiome("UnderDOCN");
    public static final FakeBiome UNDERRIVER = new FakeBiome("UnderRVR");
    public static final FakeBiome OUTERSPACE = new FakeBiome("OuterSpace");
    public static final FakeBiome CLOUDS = new FakeBiome("Clouds");
    public static final FakeBiome VILLAGE = new FakeBiome("Village");
    public static final FakeBiome BATTLE_MUSIC = new FakeBiome("BattleMusic");
    public BiomeInfo UNDERGROUND_INFO;
    public BiomeInfo PLAYER_INFO;
    public BiomeInfo UNDERRIVER_INFO;
    public BiomeInfo UNDEROCEAN_INFO;
    public BiomeInfo UNDERDEEPOCEAN_INFO;
    public BiomeInfo UNDERWATER_INFO;
    public BiomeInfo VILLAGE_INFO;
    public BiomeInfo CLOUDS_INFO;
    public BiomeInfo OUTERSPACE_INFO;
    public BiomeInfo BATTLE_MUSIC_INFO;
    public BiomeInfo WTF_INFO;
    private static final FakeBiome WTF = new WTFFakeBiome();
    private final Map<ResourceLocation, BiomeInfo> registry = new HashMap<ResourceLocation, BiomeInfo>();
    private final Map<String, String> biomeAliases = new HashMap<String, String>();

    public BiomeRegistry(@Nonnull Side side) {
        super(side);
    }

    private void register(@Nonnull Biome biome) {
        this.register(new BiomeHandler(biome));
    }

    private void register(@Nonnull IBiome biome) {
        this.registry.put(biome.getKey(), new BiomeInfo(biome));
    }

    @Override
    public void init() {
        this.biomeAliases.clear();
        this.registry.clear();
        for (String entry : ModOptions.biomes.biomeAliases) {
            String[] parts = StringUtils.split((String)entry, (String)"=");
            if (parts.length != 2) continue;
            this.biomeAliases.put(parts[0], parts[1]);
        }
        ForgeRegistries.BIOMES.getValues().forEach(biome -> this.register((Biome)biome));
        this.register(UNDERWATER);
        this.register(UNDEROCEAN);
        this.register(UNDERDEEPOCEAN);
        this.register(UNDERRIVER);
        this.register(PLAYER);
        this.register(VILLAGE);
        this.register(UNDERGROUND);
        this.register(CLOUDS);
        this.register(OUTERSPACE);
        this.register(BATTLE_MUSIC);
        this.UNDERGROUND_INFO = this.resolve(UNDERGROUND);
        this.PLAYER_INFO = this.resolve(PLAYER);
        this.UNDERRIVER_INFO = this.resolve(UNDERRIVER);
        this.UNDEROCEAN_INFO = this.resolve(UNDEROCEAN);
        this.UNDERDEEPOCEAN_INFO = this.resolve(UNDERDEEPOCEAN);
        this.UNDERWATER_INFO = this.resolve(UNDERWATER);
        this.VILLAGE_INFO = this.resolve(VILLAGE);
        this.CLOUDS_INFO = this.resolve(CLOUDS);
        this.OUTERSPACE_INFO = this.resolve(OUTERSPACE);
        this.BATTLE_MUSIC_INFO = this.resolve(BATTLE_MUSIC);
        this.register(WTF);
        this.WTF_INFO = this.resolve(WTF);
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
        cfg.biomeAlias.forEach((alias, biome) -> this.registerBiomeAlias((String)alias, (String)biome));
        cfg.biomes.forEach(biome -> this.register((BiomeConfig)biome));
    }

    @Override
    public void initComplete() {
        if (ModOptions.logging.enableDebugLogging) {
            DSurround.log().info("*** BIOME REGISTRY ***", new Object[0]);
            ArrayList<BiomeInfo> info = new ArrayList<BiomeInfo>(this.registry.values());
            Collections.sort(info);
            info.forEach(e -> DSurround.log().info(e.toString(), new Object[0]));
        }
        this.biomeAliases.clear();
    }

    @Override
    public void fini() {
    }

    @Nullable
    BiomeInfo resolve(@Nonnull IBiome biome) {
        return this.registry.get(biome.getKey());
    }

    @Nullable
    private BiomeInfo resolve(@Nonnull Biome biome) {
        return this.registry.get(BiomeHandler.getKey(biome));
    }

    @Nonnull
    public BiomeInfo get(@Nonnull Biome biome) {
        if (biome == null) {
            return this.WTF_INFO;
        }
        BiomeInfo result = this.resolve(biome);
        if (result == null) {
            DSurround.log().warn("Biome [%s] not detected during initialization - forcing reload (%s)", biome.func_185359_l(), biome.getClass());
            MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Configuration(this.side));
            result = this.resolve(biome);
            if (result == null) {
                DSurround.log().warn("Unable to locate biome [%s] (%s) after reload", biome.func_185359_l(), biome.getClass().getName());
                result = this.WTF_INFO;
            }
        }
        return result;
    }

    @Nonnull
    public BiomeInfo getPlayerBiome(@Nonnull EntityPlayer player2, boolean getTrue) {
        Biome biome = player2.func_130014_f_().func_180494_b(new BlockPos(player2.field_70165_t, 0.0, player2.field_70161_v));
        BiomeInfo info = this.get(biome);
        if (!getTrue) {
            if (player2.func_70055_a(Material.field_151586_h)) {
                info = info.isRiver() ? this.UNDERRIVER_INFO : (info.isDeepOcean() ? this.UNDERDEEPOCEAN_INFO : (info.isOcean() ? this.UNDEROCEAN_INFO : this.UNDERWATER_INFO));
            } else {
                DimensionInfo dimInfo = EnvironStateHandler.EnvironState.getDimensionInfo();
                int theY = MathStuff.floor(player2.field_70163_u);
                if (theY + 3 <= dimInfo.getSeaLevel()) {
                    info = this.UNDERGROUND_INFO;
                } else if (theY >= dimInfo.getSpaceHeight()) {
                    info = this.OUTERSPACE_INFO;
                } else if (theY >= dimInfo.getCloudHeight()) {
                    info = this.CLOUDS_INFO;
                }
            }
        }
        return info;
    }

    final boolean isBiomeMatch(@Nonnull BiomeConfig entry, @Nonnull BiomeInfo info) {
        if (Pattern.matches(entry.biomeName, info.getBiomeName())) {
            return true;
        }
        String alias = this.biomeAliases.get(info.getBiomeName());
        return alias == null ? false : Pattern.matches(entry.biomeName, alias);
    }

    public void registerBiomeAlias(@Nonnull String alias, @Nonnull String biome) {
        this.biomeAliases.put(alias, biome);
    }

    public void register(@Nonnull BiomeConfig entry) {
        BiomeMatcher matcher = BiomeMatcher.getMatcher(entry);
        this.registry.values().forEach(info -> {
            if (matcher.match((BiomeInfo)info)) {
                info.update(entry);
            }
        });
    }
}

