/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.proxy;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.ParticleCollections;
import org.blockartistry.DynSurround.client.fx.particle.ParticleDripOverride;
import org.blockartistry.DynSurround.client.gui.HumDinger;
import org.blockartistry.DynSurround.client.handlers.EffectManager;
import org.blockartistry.DynSurround.client.hud.GuiHUDHandler;
import org.blockartistry.DynSurround.client.hud.InspectionHUD;
import org.blockartistry.DynSurround.client.hud.LightLevelHUD;
import org.blockartistry.DynSurround.client.keyboard.KeyHandler;
import org.blockartistry.DynSurround.client.sound.BackgroundMute;
import org.blockartistry.DynSurround.client.sound.MusicTickerReplacement;
import org.blockartistry.DynSurround.client.sound.SoundEngine;
import org.blockartistry.DynSurround.client.weather.RenderWeather;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.commands.CommandCalc;
import org.blockartistry.DynSurround.data.PresetHandler;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.DynSurround.event.WorldEventDetector;
import org.blockartistry.DynSurround.proxy.Proxy;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.compat.ModEnvironment;
import org.blockartistry.lib.task.Scheduler;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy
implements IResourceManagerReloadListener {
    @Override
    protected void registerLanguage() {
        Localization.initialize(Side.CLIENT);
    }

    @Override
    protected void eventBusRegistrations() {
        super.eventBusRegistrations();
        ProxyClient.register(HumDinger.class);
        ProxyClient.register(InspectionHUD.class);
        ProxyClient.register(LightLevelHUD.class);
        ProxyClient.register(KeyHandler.class);
        ProxyClient.register(BackgroundMute.class);
        ProxyClient.register(RenderWeather.class);
        ProxyClient.register(Weather.class);
        ProxyClient.register(PresetHandler.class);
        ProxyClient.register(WorldEventDetector.class);
        ProxyClient.register(LightLevelHUD.class);
        ProxyClient.register(ParticleCollections.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isRunningAsServer() {
        return false;
    }

    @Override
    public Side effectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    @Override
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        super.preInit(event);
    }

    @Override
    public void init(@Nonnull FMLInitializationEvent event) {
        super.init(event);
        KeyHandler.init();
        ParticleDripOverride.register();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc());
        if (ModOptions.general.disableWaterSuspendParticle) {
            Minecraft.func_71410_x().field_71452_i.func_178929_a(EnumParticleTypes.SUSPENDED.func_179348_c(), null);
        }
        if (ModEnvironment.AmbientSounds.isLoaded()) {
            SoundEngine.configureSound(null);
        }
    }

    @Override
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        MusicTickerReplacement.initialize();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        ((IReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)this);
    }

    @Override
    public void clientConnect(@Nonnull FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Scheduler.schedule(Side.CLIENT, () -> {
            EffectManager.connect();
            GuiHUDHandler.register();
            Weather.register(DSurround.isInstalledOnServer());
            this.connectionTime = System.currentTimeMillis();
        });
    }

    @Override
    public void clientDisconnect(@Nonnull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Scheduler.schedule(Side.CLIENT, () -> {
            EffectManager.disconnect();
            GuiHUDHandler.unregister();
            Weather.unregister();
            this.connectionTime = 0L;
        });
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Resources(resourceManager));
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("dsurround")) {
            MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Configuration());
        }
    }
}

