/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.blockartistry.DynSurround.event.ThunderEvent;
import org.blockartistry.DynSurround.network.Network;

public class PacketThunder
implements IMessage {
    private int dimension;
    private boolean doFlash;
    private BlockPos pos;

    public PacketThunder() {
    }

    public PacketThunder(int dimensionId, boolean doFlash, BlockPos pos) {
        this.dimension = dimensionId;
        this.doFlash = doFlash;
        this.pos = pos;
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.dimension = buf.readShort();
        this.doFlash = buf.readBoolean();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeShort(this.dimension);
        buf.writeBoolean(this.doFlash);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static class PacketHandler
    implements IMessageHandler<PacketThunder, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketThunder message, @Nullable MessageContext ctx) {
            Network.postEvent(new ThunderEvent(message.dimension, message.doFlash, message.pos));
            return null;
        }
    }
}

