/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.blockartistry.DynSurround.event.SpeechTextEvent;
import org.blockartistry.DynSurround.network.Network;

public class PacketSpeechBubble
implements IMessage {
    protected int entityId;
    protected String message;
    protected boolean translate;

    public PacketSpeechBubble() {
    }

    public PacketSpeechBubble(@Nonnull Entity player2, @Nonnull String message, boolean translate) {
        this.entityId = player2.func_145782_y();
        this.message = message;
        this.translate = translate;
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.entityId = buf.readInt();
        this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.translate = buf.readBoolean();
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        buf.writeBoolean(this.translate);
    }

    public static class PacketHandler
    implements IMessageHandler<PacketSpeechBubble, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketSpeechBubble message, @Nullable MessageContext ctx) {
            if (message.translate) {
                return null;
            }
            Network.postEvent(new SpeechTextEvent(message.entityId, message.message, message.translate));
            return null;
        }
    }
}

