/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.blockartistry.DynSurround.entity.ActionState;
import org.blockartistry.DynSurround.entity.EmojiType;
import org.blockartistry.DynSurround.entity.EmotionalState;
import org.blockartistry.DynSurround.entity.IEmojiData;
import org.blockartistry.DynSurround.event.EntityEmojiEvent;
import org.blockartistry.DynSurround.network.Network;

public class PacketEntityEmote
implements IMessage {
    private int entityId;
    private ActionState actionState = ActionState.NONE;
    private EmotionalState emotionalState = EmotionalState.NEUTRAL;
    private EmojiType emojiType = EmojiType.NONE;

    public PacketEntityEmote() {
    }

    public PacketEntityEmote(@Nonnull IEmojiData data) {
        this.entityId = data.getEntityId();
        this.actionState = data.getActionState();
        this.emotionalState = data.getEmotionalState();
        this.emojiType = data.getEmojiType();
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.entityId = buf.readInt();
        this.actionState = ActionState.get(buf.readByte());
        this.emotionalState = EmotionalState.get(buf.readByte());
        this.emojiType = EmojiType.get(buf.readByte());
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeByte(ActionState.getId(this.actionState));
        buf.writeByte(EmotionalState.getId(this.emotionalState));
        buf.writeByte(EmojiType.getId(this.emojiType));
    }

    public static class PacketHandler
    implements IMessageHandler<PacketEntityEmote, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketEntityEmote message, @Nullable MessageContext ctx) {
            Network.postEvent(new EntityEmojiEvent(message.entityId, message.actionState, message.emotionalState, message.emojiType));
            return null;
        }
    }
}

