/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.network.Locus;
import org.blockartistry.DynSurround.network.Network;

public class PacketDisplayFootprint
implements IMessage {
    protected Locus locus;
    protected float rotation = 0.0f;
    protected boolean isRightFoot = false;

    public PacketDisplayFootprint() {
    }

    @SideOnly(value=Side.CLIENT)
    public PacketDisplayFootprint(@Nonnull Entity entity, @Nonnull Vec3d pos, float rotation, boolean rightFoot) {
        this.locus = new Locus(entity, pos, ModOptions.general.specialEffectRange);
        this.rotation = rotation;
        this.isRightFoot = rightFoot;
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.locus = new Locus(buf);
        this.rotation = buf.readFloat();
        this.isRightFoot = buf.readBoolean();
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        this.locus.toBytes(buf);
        buf.writeFloat(this.rotation);
        buf.writeBoolean(this.isRightFoot);
    }

    public static class PacketHandlerServer
    implements IMessageHandler<PacketDisplayFootprint, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketDisplayFootprint message, @Nullable MessageContext ctx) {
            message.locus = new Locus(message.locus, ModOptions.general.specialEffectRange);
            Network.sendToAllAround(message.locus, message);
            return null;
        }
    }

    public static class PacketHandler
    implements IMessageHandler<PacketDisplayFootprint, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketDisplayFootprint message, @Nullable MessageContext ctx) {
            return null;
        }
    }
}

