/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.network.Locus;
import org.blockartistry.DynSurround.network.PacketDisplayFootprint;
import org.blockartistry.DynSurround.network.PacketEntityEmote;
import org.blockartistry.DynSurround.network.PacketEnvironment;
import org.blockartistry.DynSurround.network.PacketHealthChange;
import org.blockartistry.DynSurround.network.PacketPlaySound;
import org.blockartistry.DynSurround.network.PacketServerData;
import org.blockartistry.DynSurround.network.PacketSpeechBubble;
import org.blockartistry.DynSurround.network.PacketThunder;
import org.blockartistry.DynSurround.network.PacketWeatherUpdate;
import org.blockartistry.lib.task.Scheduler;

public final class Network {
    private static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("dsurround");

    private Network() {
    }

    public static void initialize() {
        int discriminator = 0;
        NETWORK.registerMessage(PacketWeatherUpdate.PacketHandler.class, PacketWeatherUpdate.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketHealthChange.PacketHandler.class, PacketHealthChange.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketSpeechBubble.PacketHandler.class, PacketSpeechBubble.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketEntityEmote.PacketHandler.class, PacketEntityEmote.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketThunder.PacketHandler.class, PacketThunder.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketEnvironment.PacketHandler.class, PacketEnvironment.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketServerData.PacketHandler.class, PacketServerData.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketDisplayFootprint.PacketHandler.class, PacketDisplayFootprint.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketPlaySound.PacketHandler.class, PacketPlaySound.class, ++discriminator, Side.CLIENT);
        NETWORK.registerMessage(PacketDisplayFootprint.PacketHandlerServer.class, PacketDisplayFootprint.class, ++discriminator, Side.SERVER);
        NETWORK.registerMessage(PacketPlaySound.PacketHandlerServer.class, PacketPlaySound.class, ++discriminator, Side.SERVER);
    }

    @SideOnly(value=Side.CLIENT)
    static void postEvent(@Nonnull Event event) {
        Network.postEvent(Side.CLIENT, event);
    }

    private static void postEvent(@Nonnull Side side, @Nonnull Event event) {
        Scheduler.schedule(side, () -> MinecraftForge.EVENT_BUS.post(event));
    }

    static void postEventServer(@Nonnull Event event) {
        Network.postEvent(Side.SERVER, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToPlayer(@Nonnull EntityPlayerMP player2, @Nonnull IMessage msg) {
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            NETWORK.sendTo(msg, player2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToEntityViewers(@Nonnull Entity entity, @Nonnull IMessage msg) {
        Set players = ((WorldServer)entity.func_130014_f_()).func_73039_n().getTrackingPlayers(entity);
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            for (EntityPlayer player2 : players) {
                NETWORK.sendTo(msg, (EntityPlayerMP)player2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToDimension(int dimensionId, @Nonnull IMessage msg) {
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            NETWORK.sendToDimension(msg, dimensionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToAll(@Nonnull IMessage msg) {
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            NETWORK.sendToAll(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToAllAround(@Nonnull Locus point, @Nonnull IMessage msg) {
        SimpleNetworkWrapper simpleNetworkWrapper = NETWORK;
        synchronized (simpleNetworkWrapper) {
            NETWORK.sendToAllAround(msg, (NetworkRegistry.TargetPoint)point);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(@Nonnull IMessage msg) {
        NETWORK.sendToServer(msg);
    }
}

