/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.facade;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.facade.ChiselAPIFacadeAccessor;
import org.blockartistry.DynSurround.facade.ChiselFacadeAccessor;
import org.blockartistry.DynSurround.facade.CoFHCoreCoverAccessor;
import org.blockartistry.DynSurround.facade.EnderIOFacadeAccessor;
import org.blockartistry.DynSurround.facade.FacadeAccessor;

public final class FacadeHelper {
    private static final Map<Block, FacadeAccessor> crackers = new IdentityHashMap<Block, FacadeAccessor>();

    private static void addAccessor(@Nonnull List<FacadeAccessor> accessors, @Nonnull FacadeAccessor accessor) {
        if (accessor.isValid()) {
            DSurround.log().info("Facade Accessor: %s", accessor.getName());
            accessors.add(accessor);
        }
    }

    protected FacadeHelper() {
    }

    @Nonnull
    public static IBlockState resolveState(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        IBlockState newState;
        FacadeAccessor accessor;
        if (crackers.size() > 0 && (accessor = crackers.get(state.func_177230_c())) != null && accessor.isValid() && (newState = accessor.getBlockState(state, world, pos, side)) != null) {
            return newState;
        }
        return state;
    }

    static {
        ArrayList<FacadeAccessor> accessors = new ArrayList<FacadeAccessor>();
        FacadeHelper.addAccessor(accessors, new EnderIOFacadeAccessor());
        FacadeHelper.addAccessor(accessors, new CoFHCoreCoverAccessor());
        FacadeHelper.addAccessor(accessors, new ChiselAPIFacadeAccessor());
        FacadeHelper.addAccessor(accessors, new ChiselFacadeAccessor());
        if (accessors.size() > 0) {
            block0: for (Block b : Block.field_149771_c) {
                for (int i = 0; i < accessors.size(); ++i) {
                    FacadeAccessor accessor = (FacadeAccessor)accessors.get(i);
                    if (!accessor.instanceOf(b)) continue;
                    crackers.put(b, accessor);
                    continue block0;
                }
            }
        }
    }
}

