/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.facade;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.blockartistry.DynSurround.DSurround;

class FacadeAccessor {
    protected Class<?> IFacadeClass;
    protected Method accessor;

    public FacadeAccessor(@Nonnull String clazz, @Nonnull String method) {
        try {
            this.IFacadeClass = Class.forName(clazz);
            this.accessor = this.IFacadeClass != null ? this.getMethod(method) : null;
        }
        catch (Throwable t) {
            this.IFacadeClass = null;
            this.accessor = null;
        }
    }

    public String getName() {
        return this.isValid() ? this.IFacadeClass.getName() : "INVALID";
    }

    public boolean instanceOf(@Nonnull Block block2) {
        return this.isValid() && this.IFacadeClass.isInstance(block2);
    }

    protected Method getMethod(@Nonnull String method) throws Throwable {
        return this.IFacadeClass.getMethod(method, IBlockAccess.class, BlockPos.class, EnumFacing.class);
    }

    protected IBlockState call(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) throws Throwable {
        return (IBlockState)this.accessor.invoke((Object)state.func_177230_c(), world, pos, side);
    }

    public boolean isValid() {
        return this.accessor != null;
    }

    @Nullable
    public IBlockState getBlockState(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        if (this.isValid()) {
            try {
                if (this.instanceOf(state.func_177230_c())) {
                    return this.call(state, world, pos, side);
                }
            }
            catch (Throwable ex) {
                DSurround.log().catching(ex);
                this.IFacadeClass = null;
                this.accessor = null;
            }
        }
        return null;
    }
}

