/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.entity;

import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nonnull;
import org.blockartistry.DynSurround.entity.EmotionalState;

public enum ActionState {
    NONE(0, 0, EmotionalState.NEUTRAL),
    IDLE(1, 1, EmotionalState.NEUTRAL),
    ANGRY(2, 2, EmotionalState.ANGRY),
    ATTACKING(3, 1000, EmotionalState.ANGRY),
    EXPLODE(4, 2000, EmotionalState.ANGRY),
    LOOKING(5, 3, EmotionalState.NEUTRAL),
    FARMING(6, 4, EmotionalState.BUSY),
    PANIC(7, 5, EmotionalState.AFRAID),
    TEMPT(8, 6, EmotionalState.HAPPY),
    MATING(9, 7, EmotionalState.HAPPY),
    CRAZY(10, 8, EmotionalState.AFRAID),
    TRADING(11, 9, EmotionalState.HAPPY),
    PLAYING(12, 10, EmotionalState.HAPPY),
    BEGGING(13, 11, EmotionalState.HAPPY),
    WORKING(14, 12, EmotionalState.BUSY),
    EATING(15, 13, EmotionalState.HAPPY),
    FOLLOWING(16, 14, EmotionalState.NEUTRAL),
    MOVING(17, 15, EmotionalState.NEUTRAL);

    private static final TIntObjectHashMap<ActionState> lookup;
    private final int id;
    private final int priority;
    private final EmotionalState state;

    private ActionState(@Nonnull int id, int priority, EmotionalState state) {
        this.id = id;
        this.priority = priority;
        this.state = state;
    }

    public int getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public EmotionalState getEmotionalState() {
        return this.state;
    }

    @Nonnull
    public static ActionState get(int id) {
        ActionState result = (ActionState)((Object)lookup.get(id));
        if (result == null) {
            result = NONE;
        }
        return result;
    }

    public static int getId(@Nonnull ActionState state) {
        return state.getId();
    }

    static {
        lookup = new TIntObjectHashMap();
        for (ActionState state : ActionState.values()) {
            lookup.put(state.getId(), (Object)state);
        }
    }
}

