/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.data.xface;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.lib.JsonUtils;

public final class DataScripts {
    private static final File dataDirectory = DSurround.dataDirectory();
    private static final String assetDirectory = "/assets/dsurround/data/";

    @Nullable
    public static ModConfigurationFile loadFromStream(@Nonnull Reader reader) {
        try {
            return JsonUtils.load(reader, ModConfigurationFile.class);
        }
        catch (Exception ex) {
            DSurround.log().error("Unable to read stream!", ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ModConfigurationFile loadFromArchive(@Nonnull String modName) {
        String fileName = StringUtils.appendIfMissing((String)(StringUtils.appendIfMissing((String)assetDirectory, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + modName.replaceAll("[^a-zA-Z0-9.-]", "_")), (CharSequence)".json", (CharSequence[])new CharSequence[0]).toLowerCase();
        try (InputStream stream = DataScripts.class.getResourceAsStream(fileName);){
            if (stream == null) return null;
            ModConfigurationFile modConfigurationFile = DataScripts.loadFromStream(new InputStreamReader(stream));
            return modConfigurationFile;
        }
        catch (Throwable ex) {
            DSurround.log().error("Unable to run script!", ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ModConfigurationFile loadFromDirectory(@Nonnull String dataFile) {
        String workingFile = StringUtils.appendIfMissing((String)Paths.get(dataFile, new String[0]).getFileName().toString(), (CharSequence)".json", (CharSequence[])new CharSequence[0]);
        File file = new File(dataDirectory, workingFile);
        if (!file.exists()) {
            DSurround.log().warn("Could not locate script file [%s]", file.toString());
            return null;
        }
        if (!file.isFile()) {
            DSurround.log().warn("Script file [%s] is not a file", file.toString());
            return null;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            ModConfigurationFile modConfigurationFile = DataScripts.loadFromStream(new InputStreamReader(stream));
            return modConfigurationFile;
        }
        catch (Throwable ex) {
            DSurround.log().error("Unable to run script!", ex);
            return null;
        }
    }
}

