/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.data;

import java.text.DecimalFormat;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.random.XorShiftRandom;

public final class DimensionEffectData
extends WorldSavedData {
    private static final DecimalFormat FORMATTER = new DecimalFormat("0");
    public static final float MIN_INTENSITY = 0.0f;
    public static final float MAX_INTENSITY = 1.0f;
    private final Random RANDOM = XorShiftRandom.current();
    private int dimensionId = 0;
    private float intensity = 0.0f;
    private float currentIntensity = 0.0f;
    private float minIntensity = ModOptions.general.defaultMinRainStrength;
    private float maxIntensity = ModOptions.general.defaultMaxRainStrength;
    private int thunderTimer = 0;

    private DimensionEffectData(int dimension) {
        this("dsurround");
        this.dimensionId = dimension;
    }

    public DimensionEffectData(@Nonnull String identifier) {
        super(identifier);
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public float getRainIntensity() {
        return this.intensity;
    }

    public float getCurrentRainIntensity() {
        return this.currentIntensity;
    }

    public void setRainIntensity(float intensity) {
        float i = MathStuff.clamp(intensity, 0.0f, 1.0f);
        if (this.intensity != i) {
            this.intensity = i;
            this.func_76185_a();
        }
    }

    public void setCurrentRainIntensity(float intensity) {
        float i = MathStuff.clamp(intensity, 0.0f, this.intensity);
        if (this.currentIntensity != i) {
            this.currentIntensity = i;
            this.func_76185_a();
        }
    }

    public float getMinRainIntensity() {
        return this.minIntensity;
    }

    public void setMinRainIntensity(float intensity) {
        float i = MathStuff.clamp(intensity, 0.0f, this.maxIntensity);
        if (this.minIntensity != i) {
            this.minIntensity = i;
            this.func_76185_a();
        }
    }

    public float getMaxRainIntensity() {
        return this.maxIntensity;
    }

    public void setMaxRainIntensity(float intensity) {
        float i = MathStuff.clamp(intensity, this.minIntensity, 1.0f);
        if (this.maxIntensity != i) {
            this.maxIntensity = i;
            this.func_76185_a();
        }
    }

    public int getThunderTimer() {
        return this.thunderTimer;
    }

    public void setThunderTimer(int time) {
        int t = MathStuff.clamp(time, 0, Integer.MAX_VALUE);
        if (this.thunderTimer != t) {
            this.thunderTimer = t;
            this.func_76185_a();
        }
    }

    public void randomizeRain() {
        float result;
        float delta = this.maxIntensity - this.minIntensity;
        if (delta <= 0.0f) {
            result = this.minIntensity;
        } else {
            float mid = delta / 2.0f;
            result = this.minIntensity + this.RANDOM.nextFloat() * mid + this.RANDOM.nextFloat() * mid;
        }
        this.setRainIntensity(MathStuff.clamp(result, 0.01f, 1.0f));
        this.setCurrentRainIntensity(0.0f);
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        this.dimensionId = nbt.func_74762_e("d");
        this.setRainIntensity(nbt.func_74760_g("s"));
        if (nbt.func_74764_b("ci")) {
            this.setCurrentRainIntensity(nbt.func_74760_g("ci"));
        }
        if (nbt.func_74764_b("min")) {
            this.setMinRainIntensity(nbt.func_74760_g("min"));
        }
        if (nbt.func_74764_b("max")) {
            this.setMaxRainIntensity(nbt.func_74760_g("max"));
        }
        if (nbt.func_74764_b("th")) {
            this.setThunderTimer(nbt.func_74762_e("th"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbt) {
        nbt.func_74768_a("d", this.getDimensionId());
        nbt.func_74776_a("s", this.getRainIntensity());
        nbt.func_74776_a("ci", this.getCurrentRainIntensity());
        nbt.func_74776_a("min", this.getMinRainIntensity());
        nbt.func_74776_a("max", this.getMaxRainIntensity());
        nbt.func_74768_a("th", this.getThunderTimer());
        return nbt;
    }

    @Nonnull
    public String configString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dim ").append(this.dimensionId).append(": ");
        builder.append("rainIntensity [").append(FORMATTER.format(this.minIntensity * 100.0f));
        builder.append(",").append(FORMATTER.format(this.maxIntensity * 100.0f));
        builder.append("]");
        return builder.toString();
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dim ").append(this.dimensionId).append(": ");
        builder.append("rainIntensity: ").append(FORMATTER.format(this.intensity * 100.0f));
        builder.append('/').append(FORMATTER.format(this.currentIntensity * 100.0f));
        builder.append(" [").append(FORMATTER.format(this.minIntensity * 100.0f));
        builder.append(",").append(FORMATTER.format(this.maxIntensity * 100.0f));
        builder.append("], thunderTimer: ").append(this.thunderTimer);
        return builder.toString();
    }

    @Nonnull
    public static DimensionEffectData get(@Nonnull World world) {
        MapStorage storage = world.getPerWorldStorage();
        DimensionEffectData data = (DimensionEffectData)storage.func_75742_a(DimensionEffectData.class, "dsurround");
        if (data == null) {
            data = new DimensionEffectData(world.field_73011_w.getDimension());
            storage.func_75745_a("dsurround", (WorldSavedData)data);
        }
        return data;
    }

    private final class NBT {
        public static final String DIMENSION = "d";
        public static final String INTENSITY = "s";
        public static final String CURRENT_INTENSITY = "ci";
        public static final String MIN_INTENSITY = "min";
        public static final String MAX_INTENSITY = "max";
        public static final String THUNDER_TIMER = "th";

        private NBT() {
        }
    }
}

