/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.commands;

import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.data.DimensionEffectData;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.lib.Localization;

public final class CommandDS
extends CommandBase {
    private static final String COMMAND = ModOptions.commands.ds.commandNameDS;
    private static final String COMMAND_OPTION_RAIN = "rain";
    private static final String COMMAND_OPTION_THUNDER = "thunder";
    private static final String COMMAND_OPTION_STATUS = "status";
    private static final String COMMAND_OPTION_RESET = "reset";
    private static final String COMMAND_OPTION_RELOAD = "reload";
    private static final String COMMAND_OPTION_SETMIN = "setmin";
    private static final String COMMAND_OPTION_SETMAX = "setmax";
    private static final String COMMAND_OPTION_SETSTRENGTH = "setstr";
    private static final String COMMAND_OPTION_SETTIME = "settime";
    private static final String COMMAND_OPTION_CONFIG = "config";
    private static final List<String> ALIAS = ImmutableList.builder().add((Object[])ModOptions.commands.ds.commandAliasDS.split(" ")).build();
    private static final DecimalFormat FORMATTER = new DecimalFormat("0.0");
    private static final List<String> HELP = ImmutableList.builder().add((Object)(TextFormatting.GOLD + "Dynamic Surroundings command help:")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " reset")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " reload")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " config")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " status <rain|thunder|aurora>")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " settime <rain|thunder> 0-1000")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " setstr rain 0-100")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " setmin rain 0-100")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " setmax rain 0-100")).build();

    public static String rainStatusOutput(World world, DimensionEffectData data) {
        StringBuilder builder = new StringBuilder();
        float minutes = (float)world.func_72912_H().func_76083_p() / 20.0f / 60.0f;
        builder.append(data.toString());
        builder.append("; isRaining: ").append(Boolean.toString(world.func_72896_J()));
        builder.append("; isSurface: ").append(Boolean.toString(world.field_73011_w.func_76569_d()));
        builder.append("; strength: ").append(FORMATTER.format(world.func_72867_j(1.0f) * 100.0f));
        builder.append("; timer: ").append(FORMATTER.format(minutes)).append(" minutes");
        return builder.toString();
    }

    public static String thunderStatusOutput(World world, DimensionEffectData data) {
        StringBuilder builder = new StringBuilder();
        float minutes = (float)world.func_72912_H().func_76071_n() / 20.0f / 60.0f;
        builder.append("dim ").append(data.getDimensionId());
        builder.append("; isThundering: ").append(Boolean.toString(world.func_72911_I()));
        builder.append("; isSurface: ").append(Boolean.toString(world.field_73011_w.func_76569_d()));
        builder.append("; strength: ").append(FORMATTER.format(world.func_72819_i(1.0f) * 100.0f));
        builder.append("; timer: ").append(FORMATTER.format(minutes)).append(" minutes");
        return builder.toString();
    }

    public static String config(World world, DimensionEffectData data) {
        return data.configString();
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return COMMAND;
    }

    public List<String> func_71514_a() {
        return ALIAS;
    }

    public String func_71518_a(ICommandSender sender) {
        return TextFormatting.GOLD + "/" + COMMAND + " help" + TextFormatting.BLUE + " -- Help for Dynamic Surroundings";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] parms) throws CommandException {
        try {
            double d;
            EntityPlayerMP player2 = CommandDS.func_71521_c((ICommandSender)sender);
            World world = player2.field_70170_p;
            DimensionEffectData data = DimensionEffectData.get(world);
            boolean showHelp = false;
            TextComponentString feedback = null;
            if (parms.length == 0) {
                showHelp = true;
            } else if (COMMAND_OPTION_RESET.compareToIgnoreCase(parms[0]) == 0) {
                world.field_73011_w.resetRainAndThunder();
                feedback = new TextComponentString(Localization.format("dsurround.msg.RainReset", new Object[0]));
            } else if (COMMAND_OPTION_RELOAD.compareToIgnoreCase(parms[0]) == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Configuration());
                feedback = new TextComponentString(Localization.format("dsurround.msg.BiomeReload", new Object[0]));
            } else if (COMMAND_OPTION_CONFIG.compareToIgnoreCase(parms[0]) == 0) {
                feedback = new TextComponentString(CommandDS.config(world, data));
            } else if (COMMAND_OPTION_STATUS.compareToIgnoreCase(parms[0]) == 0) {
                if (parms.length < 2) {
                    showHelp = true;
                } else if (COMMAND_OPTION_RAIN.compareToIgnoreCase(parms[1]) == 0) {
                    feedback = new TextComponentString(CommandDS.rainStatusOutput(world, data));
                } else if (COMMAND_OPTION_THUNDER.compareToIgnoreCase(parms[1]) == 0) {
                    feedback = new TextComponentString(CommandDS.thunderStatusOutput(world, data));
                }
            } else if (COMMAND_OPTION_SETTIME.compareToIgnoreCase(parms[0]) == 0) {
                if (parms.length < 3) {
                    showHelp = true;
                } else {
                    d = CommandDS.func_175756_a((String)parms[2], (double)0.0, (double)1000.0) * 20.0 * 60.0;
                    if (COMMAND_OPTION_RAIN.compareToIgnoreCase(parms[1]) == 0) {
                        world.func_72912_H().func_76080_g((int)d);
                        feedback = new TextComponentString(Localization.format("dsurround.msg.RainTimeSet", FORMATTER.format(d)));
                    } else if (COMMAND_OPTION_THUNDER.compareToIgnoreCase(parms[1]) == 0) {
                        world.func_72912_H().func_76090_f((int)d);
                        feedback = new TextComponentString(Localization.format("dsurround.msg.ThunderTimeSet", FORMATTER.format(d)));
                    } else {
                        showHelp = true;
                    }
                }
            } else if (COMMAND_OPTION_SETSTRENGTH.compareToIgnoreCase(parms[0]) == 0) {
                if (parms.length < 3) {
                    showHelp = true;
                } else {
                    d = CommandDS.func_175756_a((String)parms[2], (double)0.0, (double)100.0) / 100.0;
                    if (COMMAND_OPTION_RAIN.compareToIgnoreCase(parms[1]) == 0) {
                        data.setRainIntensity((float)d);
                        feedback = new TextComponentString(Localization.format("dsurround.msg.RainIntensitySet", FORMATTER.format(data.getRainIntensity() * 100.0f)));
                    } else {
                        showHelp = true;
                    }
                }
            } else if (COMMAND_OPTION_SETMIN.compareToIgnoreCase(parms[0]) == 0) {
                if (parms.length < 3) {
                    showHelp = true;
                } else {
                    d = CommandDS.func_175756_a((String)parms[2], (double)0.0, (double)100.0) / 100.0;
                    if (COMMAND_OPTION_RAIN.compareToIgnoreCase(parms[1]) == 0) {
                        data.setMinRainIntensity((float)d);
                        feedback = new TextComponentString(Localization.format("dsurround.msg.MinRainIntensitySet", FORMATTER.format(data.getMinRainIntensity() * 100.0f)));
                    } else {
                        showHelp = true;
                    }
                }
            } else if (COMMAND_OPTION_SETMAX.compareToIgnoreCase(parms[0]) == 0) {
                if (parms.length < 3) {
                    showHelp = true;
                } else {
                    d = CommandDS.func_175756_a((String)parms[2], (double)0.0, (double)100.0) / 100.0;
                    if (COMMAND_OPTION_RAIN.compareToIgnoreCase(parms[1]) == 0) {
                        data.setMaxRainIntensity((float)d);
                        feedback = new TextComponentString(Localization.format("dsurround.msg.MaxRainIntensitySet", FORMATTER.format(data.getMaxRainIntensity() * 100.0f)));
                    } else {
                        showHelp = true;
                    }
                }
            } else {
                showHelp = true;
            }
            if (showHelp) {
                for (String line : HELP) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(line));
                }
            } else if (feedback != null) {
                player2.func_145747_a(feedback);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

