/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.commands;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.lib.expression.Expression;
import org.blockartistry.lib.expression.ExpressionException;
import org.blockartistry.lib.expression.Variant;

@SideOnly(value=Side.CLIENT)
public class CommandCalc
extends CommandBase {
    private static final String COMMAND = ModOptions.commands.calc.commandNameCalc;
    private static final String COMMAND_OPTION_HELP = "help";
    private static final String COMMAND_OPTION_FUNCS = "funcs";
    private static final String COMMAND_OPTION_VARS = "vars";
    private static final String COMMAND_OPTION_OPS = "ops";
    private static final List<String> ALIAS = ImmutableList.builder().add((Object[])ModOptions.commands.calc.commandAliasCalc.split(" ")).build();
    private static final List<String> HELP = ImmutableList.builder().add((Object)(TextFormatting.GOLD + "Calculator command help:")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " <expression>")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " funcs")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " vars")).add((Object)(TextFormatting.YELLOW + "/" + COMMAND + " ops")).build();

    public String func_71517_b() {
        return COMMAND;
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_71514_a() {
        return ALIAS;
    }

    public String func_71518_a(ICommandSender sender) {
        return TextFormatting.GOLD + "/" + COMMAND + " help" + TextFormatting.BLUE + " -- Help for Calculator";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] parms) throws CommandException {
        try {
            Expression exp;
            boolean showHelp = false;
            if (parms.length == 0) {
                showHelp = true;
            } else if (COMMAND_OPTION_HELP.compareToIgnoreCase(parms[0]) == 0) {
                showHelp = true;
            } else if (COMMAND_OPTION_FUNCS.compareToIgnoreCase(parms[0]) == 0) {
                exp = new Expression("0");
                for (String line : exp.getDeclaredFunctions()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(line));
                }
            } else if (COMMAND_OPTION_VARS.compareToIgnoreCase(parms[0]) == 0) {
                exp = new Expression("0");
                for (String line : exp.getDeclaredVariables()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(line));
                }
            } else if (COMMAND_OPTION_OPS.compareToIgnoreCase(parms[0]) == 0) {
                exp = new Expression("0");
                for (String line : exp.getDeclaredOperators()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(line));
                }
            } else {
                try {
                    exp = new Expression(CommandCalc.func_180529_a((String[])parms, (int)0));
                    Variant result = exp.eval();
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "-> " + result.asString()));
                }
                catch (ExpressionException t) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + t.getMessage()));
                }
                catch (Throwable t) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Internal error"));
                    showHelp = true;
                }
            }
            if (showHelp) {
                for (String line : HELP) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(line));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

