/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.weather;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.DynSurround.client.weather.tracker.ServerDrivenTracker;
import org.blockartistry.DynSurround.client.weather.tracker.SimulationTracker;
import org.blockartistry.DynSurround.client.weather.tracker.Tracker;
import org.blockartistry.DynSurround.event.WeatherUpdateEvent;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class Weather {
    private static Tracker tracker = new SimulationTracker();

    private static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static boolean isRaining() {
        return tracker.isRaining();
    }

    public static boolean isThundering() {
        return tracker.isThundering();
    }

    @Nonnull
    public static Properties getWeatherProperties() {
        return tracker.getWeatherProperties();
    }

    public static float getIntensityLevel() {
        return tracker.getIntensityLevel();
    }

    public static float getMaxIntensityLevel() {
        return tracker.getMaxIntensityLevel();
    }

    public static int getNextRainChange() {
        return tracker.getNextRainChange();
    }

    public static float getThunderStrength() {
        return tracker.getThunderStrength();
    }

    public static int getNextThunderChange() {
        return tracker.getNextThunderChange();
    }

    public static int getNextThunderEvent() {
        return tracker.getNextThunderEvent();
    }

    public static float getCurrentVolume() {
        return tracker.getCurrentVolume();
    }

    @Nonnull
    public static SoundEvent getCurrentStormSound() {
        return tracker.getCurrentStormSound();
    }

    @Nonnull
    public static SoundEvent getCurrentDustSound() {
        return tracker.getCurrentDustSound();
    }

    public static boolean doVanilla() {
        return tracker.doVanilla();
    }

    public static void update() {
        tracker.update();
    }

    @SubscribeEvent
    public static void onWeatherUpdateEvent(@Nonnull WeatherUpdateEvent event) {
        World world = Weather.getWorld();
        if (world == null || world.field_73011_w == null) {
            return;
        }
        if (world.field_73011_w.getDimension() != event.dimId) {
            return;
        }
        if (tracker instanceof ServerDrivenTracker) {
            ((ServerDrivenTracker)tracker).update(event);
        }
    }

    public static void register(boolean serverAvailable) {
        if (serverAvailable) {
            tracker = new ServerDrivenTracker();
        }
    }

    public static void unregister() {
        tracker = new SimulationTracker();
    }

    @Nonnull
    public static String diagnostic() {
        return tracker.toString();
    }

    public static enum Properties {
        VANILLA,
        NONE(0.0f, "calm"),
        CALM(0.165f, "calm"),
        LIGHT(0.33f, "light"),
        GENTLE(0.495f, "gentle"),
        MODERATE(0.66f, "moderate"),
        HEAVY(0.826f, "heavy"),
        STRONG(1.0f, "strong");

        private final float level;
        private final ResourceLocation rainTexture;
        private final ResourceLocation snowTexture;
        private final ResourceLocation dustTexture;

        private Properties() {
            this.level = -10.0f;
            this.rainTexture = new ResourceLocation("textures/environment/rain.png");
            this.snowTexture = new ResourceLocation("textures/environment/snow.png");
            this.dustTexture = new ResourceLocation("dsurround", "textures/environment/dust_calm.png");
        }

        private Properties(float level, String intensity) {
            this.level = level;
            this.rainTexture = new ResourceLocation("dsurround", String.format("textures/environment/rain_%s.png", intensity));
            this.snowTexture = new ResourceLocation("dsurround", String.format("textures/environment/snow_%s.png", intensity));
            this.dustTexture = new ResourceLocation("dsurround", String.format("textures/environment/dust_%s.png", intensity));
        }

        public float getLevel() {
            return this.level;
        }

        @Nonnull
        public ResourceLocation getRainTexture() {
            return this.rainTexture;
        }

        @Nonnull
        public ResourceLocation getDustTexture() {
            return this.dustTexture;
        }

        @Nonnull
        public ResourceLocation getSnowTexture() {
            return this.snowTexture;
        }

        @Nonnull
        public SoundEvent getStormSound() {
            return Sounds.RAIN;
        }

        @Nonnull
        public SoundEvent getDustSound() {
            return Sounds.DUST;
        }

        public static Properties mapRainStrength(float str) {
            Properties result = VANILLA;
            if (str == VANILLA.getLevel()) {
                result = VANILLA;
            } else {
                str = MathStuff.clamp(str, 0.0f, 1.0f);
                result = NONE;
                for (int i = 0; i < Properties.values().length; ++i) {
                    Properties p = Properties.values()[i];
                    if (!(str <= p.getLevel())) continue;
                    result = p;
                    break;
                }
            }
            return result;
        }
    }
}

