/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.weather;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.weather.StormRenderer;
import org.blockartistry.DynSurround.client.weather.StormSplashRenderer;

@SideOnly(value=Side.CLIENT)
public final class RenderWeather
extends IRenderHandler {
    private final StormRenderer renderer = new StormRenderer();
    public static int rendererUpdateCount = 0;

    protected RenderWeather() {
    }

    public static void addRainParticles(@Nonnull EntityRenderer theThis) {
        ++rendererUpdateCount;
        if (EnvironStateHandler.EnvironState.getWorld() != null) {
            StormSplashRenderer.renderStormSplashes(EnvironStateHandler.EnvironState.getDimensionId(), theThis);
        }
    }

    public void render(float partialTicks, @Nonnull WorldClient world, @Nonnull Minecraft mc) {
        this.renderer.render(mc.field_71460_t, partialTicks);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(@Nonnull WorldEvent.Load e) {
        if (DSurround.proxy().effectiveSide() == Side.SERVER || !ModOptions.asm.enableWeatherASM) {
            return;
        }
        WorldProvider provider = e.getWorld().field_73011_w;
        String dimName = provider.func_186058_p().func_186065_b();
        IRenderHandler renderer = provider.getWeatherRenderer();
        if (renderer == null) {
            DSurround.log().info("Setting weather renderer for dimension [%s]", dimName);
            provider.setWeatherRenderer((IRenderHandler)new RenderWeather());
        } else {
            DSurround.log().info("Not hooking weather renderer for dimension [%s] (%s)", dimName, renderer.getClass());
        }
    }
}

