/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.swing;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.implem.BlockMap;
import org.blockartistry.DynSurround.client.fx.BlockEffect;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.expression.ExpressionEngine;
import org.blockartistry.DynSurround.registry.BlockInfo;
import org.blockartistry.lib.MCHelper;
import org.blockartistry.lib.expression.IDynamicVariant;

@SideOnly(value=Side.CLIENT)
public abstract class DataProxy
extends Observable {
    public static final List<Observable> dataPools = new ArrayList<Observable>();

    public static void update() {
        for (Observable o : dataPools) {
            o.notifyObservers();
        }
    }

    @Override
    public void notifyObservers() {
        this.setChanged();
        super.notifyObservers();
    }

    @SideOnly(value=Side.CLIENT)
    public static class ViewedBlockData
    extends DataProxy {
        protected final BlockInfo.BlockInfoMutable mutable = new BlockInfo.BlockInfoMutable();
        protected BlockPos targetBlock = BlockPos.field_177992_a;
        protected IBlockState state;

        public ViewedBlockData() {
            dataPools.add(this);
        }

        @Override
        public void notifyObservers() {
            RayTraceResult current = Minecraft.func_71410_x().field_71476_x;
            this.targetBlock = current == null || current.func_178782_a() == null ? BlockPos.field_177992_a : current.func_178782_a();
            this.state = EnvironStateHandler.EnvironState.getWorld().func_180495_p(this.targetBlock);
            this.mutable.set(this.state);
            super.notifyObservers();
        }

        public String getBlockName() {
            return this.mutable.toString();
        }

        public String getBlockMaterial() {
            return MCHelper.getMaterialName(this.state.func_185904_a());
        }

        public List<String> getFootstepAcoustics() {
            ArrayList<String> result = new ArrayList<String>();
            BlockMap bm = ClientRegistry.FOOTSTEPS.getBlockMap();
            if (bm != null) {
                ArrayList<String> data = new ArrayList<String>();
                bm.collectData(EnvironStateHandler.EnvironState.getWorld(), this.state, this.targetBlock, data);
                result.addAll(data);
            }
            return result;
        }

        public List<String> getBlockEffects() {
            BlockEffect[] effects2;
            ArrayList<String> result = new ArrayList<String>();
            for (BlockEffect e : effects2 = ClientRegistry.BLOCK.getEffects(this.state)) {
                result.add(e.getEffectType().getName());
            }
            for (BlockEffect e : effects2 = ClientRegistry.BLOCK.getAlwaysOnEffects(this.state)) {
                result.add(e.getEffectType().getName() + " (Always on)");
            }
            return result;
        }

        public List<String> getBlockSounds() {
            SoundEffect[] sounds;
            ArrayList<String> result = new ArrayList<String>();
            for (SoundEffect s : sounds = ClientRegistry.BLOCK.getAllSounds(this.state)) {
                result.add(s.toString());
            }
            sounds = ClientRegistry.BLOCK.getAllStepSounds(this.state);
            if (sounds.length > 0) {
                for (SoundEffect s : sounds) {
                    result.add(s.toString() + " (Step Sound)");
                }
            }
            return result;
        }

        public List<String> getBlockOreDictionary() {
            ItemStack stack;
            ArrayList<String> result = new ArrayList<String>();
            Item item = Item.func_150898_a((Block)this.state.func_177230_c());
            if (item != null && (stack = this.state.func_177230_c().getPickBlock(this.state, Minecraft.func_71410_x().field_71476_x, EnvironStateHandler.EnvironState.getWorld(), this.targetBlock, EnvironStateHandler.EnvironState.getPlayer())) != null) {
                for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                    result.add(OreDictionary.getOreName((int)i));
                }
            }
            return result;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class WeatherData
    extends DataProxy {
        public WeatherData() {
            dataPools.add(this);
        }

        public String getRainStatus() {
            return Weather.getWeatherProperties().name();
        }

        public float getRainIntensity() {
            return Weather.getIntensityLevel();
        }

        public int getRainTime() {
            return Weather.getNextRainChange();
        }

        public float getThunderStrength() {
            return Weather.getThunderStrength();
        }

        public int getThunderTime() {
            return Weather.getNextThunderChange();
        }

        public int getNextThunderEvent() {
            return Weather.getNextThunderEvent();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ScriptVariableData
    extends DataProxy {
        public ScriptVariableData() {
            dataPools.add(this);
        }

        public List<IDynamicVariant<?>> getVariables() {
            return ExpressionEngine.instance().getVariables();
        }
    }
}

