/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.registry.SoundMetadata;
import org.blockartistry.lib.sound.SoundConfigProcessor;
import org.blockartistry.lib.streams.StreamUtil;

@Mod.EventBusSubscriber
public class SoundLoader {
    private static final Map<ResourceLocation, SoundMetadata> soundMetadata = new HashMap<ResourceLocation, SoundMetadata>();
    private static final Map<ResourceLocation, SoundEvent> myRegistry = new HashMap<ResourceLocation, SoundEvent>();
    private static SoundEvent SILENCE;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        DSurround.log().info("Registering sounds", new Object[0]);
        ResourceLocation soundFile = new ResourceLocation("dsurround", "sounds.json");
        IForgeRegistry registry = event.getRegistry();
        try (SoundConfigProcessor proc = new SoundConfigProcessor(soundFile);){
            proc.forEach((sound2, meta) -> {
                SoundMetadata data = new SoundMetadata(meta);
                ResourceLocation resource = new ResourceLocation("dsurround", sound2);
                SoundEvent se = (SoundEvent)new SoundEvent(resource).setRegistryName(resource);
                registry.register((IForgeRegistryEntry)se);
                soundMetadata.put(resource, data);
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StreamUtil.asStream(SoundEvent.field_187505_a.iterator()).forEach(se -> myRegistry.put(se.getRegistryName(), (SoundEvent)se));
        StreamUtil.asStream(registry.iterator()).forEach(se -> myRegistry.put(se.getRegistryName(), (SoundEvent)se));
        SILENCE = myRegistry.get(new ResourceLocation("dsurround", "silence"));
        DSurround.log().info("%d sound events in registry", myRegistry.size());
    }

    @Nullable
    public static SoundMetadata getSoundMetadata(@Nonnull ResourceLocation resource) {
        return soundMetadata.get(resource);
    }

    @Nonnull
    public static SoundEvent getSound(ResourceLocation sound2) {
        SoundEvent evt = myRegistry.get(sound2);
        if (evt == null) {
            DSurround.log().warn("Cannot find sound that should be registered [%s]", sound2.toString());
            return SILENCE;
        }
        return evt;
    }
}

