/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.sound.fix.SoundFixMethods;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.lib.ThreadGuard;
import org.blockartistry.lib.collections.IdentityHashSet;
import org.blockartistry.lib.compat.ModEnvironment;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.sound.ITrackedSound;
import org.blockartistry.lib.sound.SoundState;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class SoundEngine {
    private static Field soundPhysicsGlobalVolume;
    private static final Field getSoundManager;
    private static final Field getSoundRegistry;
    private static final Field getSoundSystem;
    private static final Field getPlayingSounds;
    private static final Field getDelayedSounds;
    private static final Field getSoundLibrary;
    private static final float MUTE_VOLUME = 1.0E-5f;
    private static final int MAX_STREAM_CHANNELS = 16;
    private static final int SOUND_QUEUE_SLACK = 6;
    private static int maxSounds;
    private static SoundEngine instance_;
    private final ThreadGuard guard = new ThreadGuard(DSurround.log(), Side.CLIENT, "SoundManager").setAction(DSurround.isDeveloperMode() ? ThreadGuard.Action.EXCEPTION : (ModOptions.logging.enableDebugLogging ? ThreadGuard.Action.LOG : ThreadGuard.Action.NONE));
    private final Set<ITrackedSound> queuedSounds = new IdentityHashSet();
    private String playedSoundId = null;

    public static SoundEngine instance() {
        if (instance_ == null) {
            instance_ = new SoundEngine();
        }
        return instance_;
    }

    private SoundEngine() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    public SoundRegistry getSoundRegistry() {
        return (SoundRegistry)this.resolve(getSoundRegistry, Minecraft.func_71410_x().func_147118_V());
    }

    @Nonnull
    public SoundManager getSoundManager() {
        return (SoundManager)this.resolve(getSoundManager, Minecraft.func_71410_x().func_147118_V());
    }

    private <T> T resolve(@Nonnull Field f, @Nonnull Object obj) {
        try {
            return (T)f.get(obj);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int currentSoundCount() {
        try {
            Object object = SoundSystemConfig.THREAD_SYNC;
            synchronized (object) {
                return this.getSoundLibrary().getSources().size();
            }
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private boolean canFitSound() {
        return this.currentSoundCount() < maxSounds - 6;
    }

    public static void flushSound() {
        SoundEngine.instance().flushSoundQueue();
    }

    private void flushSoundQueue() {
        this.getSoundSystem().CommandQueue(null);
    }

    protected SoundSystem getSoundSystem() {
        return (SoundSystem)this.resolve(getSoundSystem, this.getSoundManager());
    }

    protected Library getSoundLibrary() {
        return (Library)this.resolve(getSoundLibrary, this.getSoundSystem());
    }

    protected Map<String, ISound> getPlayingSounds() {
        return (Map)this.resolve(getPlayingSounds, this.getSoundManager());
    }

    protected Map<ISound, Integer> getDelayedSounds() {
        return (Map)this.resolve(getDelayedSounds, this.getSoundManager());
    }

    public boolean isSoundPlaying(@Nonnull ITrackedSound sound2) {
        return sound2.getState().isActive() && this.queuedSounds.contains(sound2);
    }

    public void stopSound(@Nonnull ITrackedSound sound2) {
        if (sound2.getState().isActive()) {
            this.getSoundSystem().stop(sound2.getId());
            this.getDelayedSounds().remove(sound2);
            this.flushSoundQueue();
        }
    }

    public void stopAllSounds() {
        this.getSoundManager().func_148614_c();
        this.flushSoundQueue();
        this.clearOrphans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String playSound(@Nonnull ITrackedSound sound2) {
        if (!StringUtils.isEmpty((CharSequence)sound2.getId())) {
            this.stopSound(sound2);
        }
        sound2.setId("");
        sound2.setState(SoundState.NONE);
        if (!this.canFitSound()) {
            DSurround.log().debug("> NO ROOM: [%s]", sound2.toString());
            sound2.setState(SoundState.ERROR);
        } else {
            if (!ModEnvironment.ActualMusic.isLoaded() || sound2.func_184365_d() != SoundCategory.MUSIC) {
                Object object = SoundSystemConfig.THREAD_SYNC;
                synchronized (object) {
                    this.playedSoundId = null;
                    this.getSoundManager().func_148611_c((ISound)sound2);
                    if (this.playedSoundId != null) {
                        sound2.setId(this.playedSoundId);
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)sound2.getId())) {
                sound2.setState(SoundState.ERROR);
            } else {
                sound2.setState(SoundState.PLAYING);
            }
            if (sound2.getState().isActive()) {
                DSurround.log().debug("> QUEUED: [%s]", sound2.toString());
                this.queuedSounds.add(sound2);
            } else if (ModOptions.logging.enableDebugLogging) {
                DSurround.log().debug("> NOT QUEUED: [%s]", sound2.toString());
            }
        }
        return sound2.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOrphans() {
        Map<String, ISound> playingSounds = this.getPlayingSounds();
        SoundSystem sndSystem = this.getSoundSystem();
        Object object = SoundSystemConfig.THREAD_SYNC;
        synchronized (object) {
            HashMap sounds = this.getSoundLibrary().getSources();
            List<String> remove = sounds.entrySet().stream().filter(e -> !playingSounds.containsKey(e.getKey())).map(e -> {
                Source src = (Source)e.getValue();
                DSurround.log().debug("Killing orphaned sound [%s]", src.filenameURL != null ? src.filenameURL.getFilename() : "UNKNOWN");
                SoundFixMethods.cleanupSource(src);
                return (String)e.getKey();
            }).collect(Collectors.toList());
            remove.forEach(id -> sndSystem.removeSource(id));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            Map<ISound, Integer> delayedSounds = this.getDelayedSounds();
            SoundManager manager = this.getSoundManager();
            this.queuedSounds.removeIf(sound2 -> {
                switch (sound2.getState()) {
                    case DELAYED: {
                        if (delayedSounds.containsKey(sound2)) break;
                        if (manager.func_148597_a((ISound)sound2)) {
                            sound2.setState(SoundState.PLAYING);
                            break;
                        }
                        sound2.setState(SoundState.DONE);
                        break;
                    }
                    case PLAYING: {
                        if (manager.func_148597_a((ISound)sound2)) break;
                        if (delayedSounds.containsKey(sound2)) {
                            sound2.setState(SoundState.DELAYED);
                            break;
                        }
                        sound2.setState(SoundState.DONE);
                        break;
                    }
                }
                return !sound2.getState().isActive();
            });
        }
    }

    public boolean isMuted() {
        try {
            return this.getSoundSystem().getMasterVolume() == 1.0E-5f;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void setMuted(boolean flag) {
        try {
            if (flag) {
                this.getSoundSystem().setMasterVolume(1.0E-5f);
            } else {
                GameSettings options = Minecraft.func_71410_x().field_71474_y;
                if (options != null) {
                    this.getSoundSystem().setMasterVolume(options.func_186711_a(SoundCategory.MASTER));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onSoundSourceEvent(@Nonnull SoundEvent.SoundSourceEvent event) {
        this.guard.check("playSound");
        this.playedSoundId = event.getUuid();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void diagnostics(DiagnosticEvent.Gather event) {
        int soundCount = this.currentSoundCount();
        int maxCount = maxSounds;
        event.output.add("SoundSystem: " + soundCount + "/" + maxCount);
        TObjectIntHashMap counts = new TObjectIntHashMap();
        for (Map.Entry<String, ISound> entry : this.getPlayingSounds().entrySet()) {
            ISound isound = entry.getValue();
            counts.adjustOrPutValue((Object)isound.func_184364_b().func_188719_a(), 1, 1);
        }
        ArrayList<String> results = new ArrayList<String>();
        TObjectIntIterator itr = counts.iterator();
        while (itr.hasNext()) {
            itr.advance();
            results.add(String.format(TextFormatting.GOLD + "%s: %d", ((ResourceLocation)itr.key()).toString(), itr.value()));
        }
        Collections.sort(results);
        event.output.addAll(results);
    }

    private static float getVolume(@Nonnull SoundCategory category) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        return settings != null && category != null && category != SoundCategory.MASTER ? settings.func_186711_a(category) : 1.0f;
    }

    private static float getVolumeScale(@Nonnull ISound sound2) {
        try {
            return ClientRegistry.SOUND.getVolumeScale(sound2);
        }
        catch (Throwable throwable) {
            return 1.0f;
        }
    }

    public static float getClampedVolume(@Nonnull ISound sound2) {
        float volumeScale = SoundEngine.getVolumeScale(sound2);
        float volume = sound2.func_147653_e() * SoundEngine.getVolume(sound2.func_184365_d()) * volumeScale;
        float result = MathStuff.clamp(volume, 0.0f, 1.0f);
        try {
            if (soundPhysicsGlobalVolume != null) {
                return result * soundPhysicsGlobalVolume.getFloat(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void alErrorCheck() {
        int error = AL10.alGetError();
        if (error != 0) {
            DSurround.log().warn("OpenAL error: %d", error);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void configureSound(@Nonnull SoundSetupEvent event) {
        int totalChannels = -1;
        try {
            boolean create;
            boolean bl = create = !AL.isCreated();
            if (create) {
                AL.create();
                SoundEngine.alErrorCheck();
            }
            IntBuffer ib = BufferUtils.createIntBuffer((int)1);
            ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4112, (IntBuffer)ib);
            SoundEngine.alErrorCheck();
            totalChannels = ib.get(0);
            if (create) {
                AL.destroy();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int normalChannelCount = ModOptions.sound.normalSoundChannelCount;
        int streamChannelCount = ModOptions.sound.streamingSoundChannelCount;
        if (ModOptions.sound.autoConfigureChannels && totalChannels > 64) {
            totalChannels = (totalChannels + 1) * 3 / 4;
            streamChannelCount = Math.min(totalChannels / 5, 16);
            normalChannelCount = totalChannels - streamChannelCount;
        }
        DSurround.log().info("Sound channels: %d normal, %d streaming (total avail: %s)", normalChannelCount, streamChannelCount, totalChannels == -1 ? "UNKNOWN" : Integer.toString(totalChannels));
        SoundSystemConfig.setNumberNormalChannels((int)normalChannelCount);
        SoundSystemConfig.setNumberStreamingChannels((int)streamChannelCount);
        maxSounds = SoundSystemConfig.getNumberNormalChannels() + SoundSystemConfig.getNumberStreamingChannels();
        if (ModOptions.sound.streamBufferCount != 0) {
            SoundSystemConfig.setNumberStreamingBuffers((int)ModOptions.sound.streamBufferCount);
        }
        if (ModOptions.sound.streamBufferSize != 0) {
            SoundSystemConfig.setStreamingBufferSize((int)(ModOptions.sound.streamBufferSize * 1024));
        }
        DSurround.log().info("Stream buffers: %d x %d", SoundSystemConfig.getNumberStreamingBuffers(), SoundSystemConfig.getStreamingBufferSize());
    }

    static {
        try {
            Class<?> soundPhysics = Class.forName("com.sonicether.soundphysics.SoundPhysics");
            soundPhysicsGlobalVolume = ReflectionHelper.findField(soundPhysics, (String[])new String[]{"globalVolumeMultiplier"});
        }
        catch (Exception ex) {
            soundPhysicsGlobalVolume = null;
        }
        getSoundManager = ReflectionHelper.findField(SoundHandler.class, (String[])new String[]{"sndManager", "field_147694_f"});
        getSoundRegistry = ReflectionHelper.findField(SoundHandler.class, (String[])new String[]{"soundRegistry", "field_147697_e"});
        getSoundSystem = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"sndSystem", "field_148620_e"});
        getPlayingSounds = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"playingSounds", "field_148629_h"});
        getDelayedSounds = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"delayedSounds", "field_148626_m"});
        getSoundLibrary = ReflectionHelper.findField(SoundSystem.class, (String[])new String[]{"soundLibrary"});
        maxSounds = 0;
    }
}

