/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.gui.ConfigSound;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.sound.BasicSound;
import org.blockartistry.DynSurround.client.sound.MusicSound;
import org.blockartistry.DynSurround.client.sound.SoundEngine;
import org.blockartistry.lib.compat.ModEnvironment;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.sound.ITrackedSound;

@SideOnly(value=Side.CLIENT)
public class MusicTickerReplacement
extends MusicTicker {
    private static final float MIN_VOLUME_SCALE = 0.001f;
    private static final float FADE_AMOUNT = 0.02f;
    private float currentScale = 1.0f;
    private final BasicSound.ISoundScale MUSIC_SCALER = () -> this.currentScale;

    public MusicTickerReplacement(@Nonnull Minecraft mcIn) {
        super(mcIn);
    }

    public void func_73660_a() {
        this.currentScale = EnvironStateHandler.EnvironState.getBattleScanner().inBattle() ? (this.currentScale -= 0.04f) : (this.currentScale += 0.02f);
        this.currentScale = MathStuff.clamp(this.currentScale, 0.001f, 1.0f);
        if (this.field_147678_c instanceof ConfigSound) {
            if (!SoundEngine.instance().isSoundPlaying((ITrackedSound)this.field_147678_c)) {
                this.field_147678_c = null;
                this.field_147676_d = 60;
                super.func_73660_a();
            }
        } else {
            super.func_73660_a();
        }
    }

    public void setPlaying(@Nonnull ConfigSound sound2) {
        this.func_181557_a();
        this.field_147678_c = sound2;
        SoundEngine.instance().playSound((ITrackedSound)this.field_147678_c);
    }

    public void func_181558_a(@Nonnull MusicTicker.MusicType requestedMusicType) {
        this.field_147678_c = new MusicSound(requestedMusicType.func_188768_a()).setVolumeScale(this.MUSIC_SCALER);
        SoundEngine.instance().playSound((ITrackedSound)this.field_147678_c);
        this.field_147676_d = Integer.MAX_VALUE;
    }

    public void func_181557_a() {
        if (this.field_147678_c != null) {
            SoundEngine.instance().stopSound((ITrackedSound)this.field_147678_c);
            this.field_147678_c = null;
            this.field_147676_d = 0;
        }
    }

    public static void initialize() {
        if (ModEnvironment.ActualMusic.isLoaded()) {
            DSurround.log().info("ActualMusic is installed; MusicTicker is NOT being replaced!", new Object[0]);
        } else {
            try {
                Field ticker = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"mcMusicTicker", "field_147126_aw"});
                if (ticker != null) {
                    Minecraft mc = Minecraft.func_71410_x();
                    ticker.set(mc, (Object)new MusicTickerReplacement(mc));
                }
            }
            catch (Throwable t) {
                DSurround.log().error("Unable to replace MusicTicker!", t);
            }
        }
    }
}

