/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.keyboard;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.Permissions;
import org.blockartistry.DynSurround.client.gui.VolumeControlGui;
import org.blockartistry.DynSurround.client.hud.LightLevelHUD;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.compat.EntityRendererUtil;

@SideOnly(value=Side.CLIENT)
public class KeyHandler {
    private static final String SECTION_NAME = "Dynamic Surroundings";
    private static KeyBinding SELECTIONBOX_KEY;
    private static KeyBinding LIGHTLEVEL_KEY;
    private static KeyBinding CHUNKBORDER_KEY;
    private static KeyBinding VOLUME_KEY;
    private static final String chatPrefix;

    public static void init() {
        SELECTIONBOX_KEY = new KeyBinding("dsurround.cfg.keybind.SelectionBox", 48, SECTION_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)SELECTIONBOX_KEY);
        VOLUME_KEY = new KeyBinding("dsurround.cfg.keybind.Volume", 47, SECTION_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)VOLUME_KEY);
        if (Permissions.instance().allowLightLevelHUD()) {
            LIGHTLEVEL_KEY = new KeyBinding("dsurround.cfg.keybind.LightLevel", 38, SECTION_NAME);
            ClientRegistry.registerKeyBinding((KeyBinding)LIGHTLEVEL_KEY);
        } else {
            LIGHTLEVEL_KEY = null;
        }
        if (Permissions.instance().allowChunkBorderHUD()) {
            CHUNKBORDER_KEY = new KeyBinding("dsurround.cfg.keybind.ChunkBorders", 67, SECTION_NAME);
            ClientRegistry.registerKeyBinding((KeyBinding)CHUNKBORDER_KEY);
        } else {
            CHUNKBORDER_KEY = null;
        }
    }

    private static String getOnOff(boolean flag) {
        return Localization.format(flag ? "dsurround.cfg.keybind.msg.ON" : "dsurround.cfg.keybind.msg.OFF", new Object[0]);
    }

    private static void sendPlayerMessage(String fmt, Object ... parms) {
        if (ModOptions.general.hideChatNotices) {
            return;
        }
        EntityPlayerSP player2 = Minecraft.func_71410_x().field_71439_g;
        if (player2 != null) {
            String txt = chatPrefix + Localization.format(fmt, parms);
            player2.func_145747_a((ITextComponent)new TextComponentString(txt));
        }
    }

    private static boolean shouldHandle(@Nonnull KeyBinding binding) {
        return binding != null && binding.func_151468_f();
    }

    @SubscribeEvent(receiveCanceled=false)
    public static void onKeyboard(@Nonnull InputEvent.KeyInputEvent event) {
        if (KeyHandler.shouldHandle(SELECTIONBOX_KEY)) {
            EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
            boolean result = !EntityRendererUtil.getDrawBlockOutline(renderer);
            EntityRendererUtil.setDrawBlockOutline(renderer, result);
            KeyHandler.sendPlayerMessage("dsurround.cfg.keybind.msg.Fencing", KeyHandler.getOnOff(result));
        }
        if (KeyHandler.shouldHandle(VOLUME_KEY) && Minecraft.func_71410_x().field_71462_r == null) {
            VolumeControlGui gui = new VolumeControlGui();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
        }
        if (KeyHandler.shouldHandle(CHUNKBORDER_KEY)) {
            boolean result = Minecraft.func_71410_x().field_184132_p.func_190075_b();
            KeyHandler.sendPlayerMessage("dsurround.cfg.keybind.msg.ChunkBorder", KeyHandler.getOnOff(result));
        }
        if (KeyHandler.shouldHandle(LIGHTLEVEL_KEY)) {
            if (GuiScreen.func_146271_m()) {
                if (LightLevelHUD.showHUD) {
                    if (++ModOptions.lightlevel.llDisplayMode >= LightLevelHUD.Mode.values().length) {
                        ModOptions.lightlevel.llDisplayMode = 0;
                    }
                    KeyHandler.sendPlayerMessage("dsurround.cfg.keybind.msg.LLDisplayMode", LightLevelHUD.Mode.getMode(ModOptions.lightlevel.llDisplayMode).name());
                }
            } else if (GuiScreen.func_146272_n()) {
                if (LightLevelHUD.showHUD) {
                    ModOptions.lightlevel.llHideSafe = !ModOptions.lightlevel.llHideSafe;
                    KeyHandler.sendPlayerMessage("dsurround.cfg.keybind.msg.LLSafeBlocks", KeyHandler.getOnOff(ModOptions.lightlevel.llHideSafe));
                }
            } else {
                LightLevelHUD.showHUD = !LightLevelHUD.showHUD;
                KeyHandler.sendPlayerMessage("dsurround.cfg.keybind.msg.LLDisplay", KeyHandler.getOnOff(LightLevelHUD.showHUD));
            }
        }
    }

    static {
        chatPrefix = TextFormatting.BLUE + "[" + TextFormatting.GREEN + SECTION_NAME + TextFormatting.BLUE + "] " + TextFormatting.RESET;
    }
}

