/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.hud;

import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientChunkCache;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.hud.GuiOverlay;
import org.blockartistry.DynSurround.client.hud.LightLevelTextureSheet;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.chunk.IBlockAccessEx;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.gfx.OpenGlState;
import org.blockartistry.lib.gfx.OpenGlUtil;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class LightLevelHUD
extends GuiOverlay {
    private static FontRenderer font;
    private static LightLevelTextureSheet sheet;
    public static boolean showHUD;
    private static final int ALLOCATION_SIZE = 2048;
    private static final ObjectArray<LightCoord> lightLevels;
    private static final BlockPos.MutableBlockPos mutable;
    private static int nextCoord;
    private static final Frustum frustum;

    private static LightCoord nextCoord() {
        if (nextCoord == lightLevels.size()) {
            lightLevels.add(new LightCoord());
        }
        return lightLevels.get(nextCoord++);
    }

    protected static boolean inFrustum(double x, double y, double z) {
        return frustum.func_78548_b(x, y, z, x, y, z);
    }

    protected static boolean renderLightLevel(@Nonnull IBlockState state, @Nonnull IBlockState below) {
        Material stateMaterial = state.func_185904_a();
        Material belowMaterial = below.func_185904_a();
        return !stateMaterial.func_76220_a() && !stateMaterial.func_76224_d() && belowMaterial.func_76220_a();
    }

    protected static boolean canMobSpawn(@Nonnull BlockPos pos) {
        return WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)EnvironStateHandler.EnvironState.getWorld(), (BlockPos)pos);
    }

    protected static float heightAdjustment(@Nonnull IBlockState state, @Nonnull IBlockState below, @Nonnull BlockPos pos) {
        if (state.func_177230_c() == Blocks.field_150350_a) {
            AxisAlignedBB box = below.func_185890_d(EnvironStateHandler.EnvironState.getWorld(), pos.func_177977_b());
            return box == null ? 0.0f : (float)box.field_72337_e - 1.0f;
        }
        AxisAlignedBB box = state.func_185890_d(EnvironStateHandler.EnvironState.getWorld(), pos);
        if (box == null) {
            return 0.0f;
        }
        float adjust = (float)box.field_72337_e;
        return state.func_177230_c() == Blocks.field_150431_aC ? adjust + 0.125f : adjust;
    }

    protected static void updateLightInfo(@Nonnull RenderManager manager, double x, double y, double z) {
        double fZ;
        double fY;
        double fX;
        font = Minecraft.func_71410_x().field_71466_p;
        boolean isThirdPerson = manager.field_78733_k.field_74320_O == 2;
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        Vec3d lookVec = player2.func_70040_Z();
        if (isThirdPerson) {
            fX = x + lookVec.field_72450_a * 2.0;
            fY = y + lookVec.field_72448_b * 2.0;
            fZ = z + lookVec.field_72449_c * 2.0;
        } else {
            fX = x - lookVec.field_72450_a * 2.0;
            fY = y - lookVec.field_72448_b * 2.0;
            fZ = z - lookVec.field_72449_c * 2.0;
        }
        frustum.func_78547_a(fX, fY, fZ);
        nextCoord = 0;
        ColorSet colors = ColorSet.getStyle(ModOptions.lightlevel.llColors);
        Mode displayMode = Mode.getMode(ModOptions.lightlevel.llDisplayMode);
        int skyLightSub = EnvironStateHandler.EnvironState.getWorld().func_72967_a(1.0f);
        int rangeXZ = ModOptions.lightlevel.llBlockRange * 2 + 1;
        int rangeY = ModOptions.lightlevel.llBlockRange + 1;
        int originX = MathStuff.floor(x) - rangeXZ / 2;
        int originZ = MathStuff.floor(z) - rangeXZ / 2;
        int originY = MathStuff.floor(y) - (rangeY - 3);
        IBlockAccessEx blocks = ClientChunkCache.INSTANCE;
        for (int dX = 0; dX < rangeXZ; ++dX) {
            for (int dZ = 0; dZ < rangeXZ; ++dZ) {
                int trueX = originX + dX;
                int trueZ = originZ + dZ;
                if (!blocks.isAvailable(trueX, trueZ)) {
                    return;
                }
                IBlockState lastState = null;
                for (int dY = 0; dY < rangeY; ++dY) {
                    int trueY = originY + dY;
                    if (trueY < 1 || !LightLevelHUD.inFrustum(trueX, trueY, trueZ)) continue;
                    IBlockState state = blocks.getBlockState(trueX, trueY, trueZ);
                    if (lastState == null) {
                        lastState = blocks.getBlockState(trueX, trueY - 1, trueZ);
                    }
                    if (LightLevelHUD.renderLightLevel(state, lastState)) {
                        mutable.func_181079_c(trueX, trueY, trueZ);
                        boolean mobSpawn = LightLevelHUD.canMobSpawn((BlockPos)mutable);
                        if (mobSpawn || !ModOptions.lightlevel.llHideSafe) {
                            int blockLight = blocks.getLightFor(EnumSkyBlock.BLOCK, (BlockPos)mutable);
                            int skyLight = blocks.getLightFor(EnumSkyBlock.SKY, (BlockPos)mutable) - skyLightSub;
                            int effective = Math.max(blockLight, skyLight);
                            int result = displayMode == Mode.BLOCK_SKY ? effective : blockLight;
                            Color color = colors.safe;
                            if (!mobSpawn) {
                                color = colors.noSpawn;
                            } else if (blockLight <= ModOptions.lightlevel.llSpawnThreshold) {
                                color = effective > ModOptions.lightlevel.llSpawnThreshold ? colors.caution : colors.hazard;
                            }
                            if (color != colors.safe || !ModOptions.lightlevel.llHideSafe) {
                                LightCoord coord = LightLevelHUD.nextCoord();
                                coord.x = trueX;
                                coord.y = (float)trueY + LightLevelHUD.heightAdjustment(state, lastState, (BlockPos)mutable);
                                coord.z = trueZ;
                                coord.lightLevel = result;
                                coord.color = color;
                            }
                        }
                    }
                    lastState = state;
                }
            }
        }
    }

    @Override
    public void doTick(int tickRef) {
        if (!showHUD || tickRef == 0 || tickRef % 3 != 0) {
            return;
        }
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        LightLevelHUD.updateLightInfo(manager, manager.field_78730_l, manager.field_78731_m, manager.field_78728_n);
    }

    @SubscribeEvent
    public static void doRender(@Nonnull RenderWorldLastEvent event) {
        if (!showHUD || nextCoord == 0) {
            return;
        }
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        if (player2 == null) {
            return;
        }
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        OpenGlState glState = OpenGlState.push();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (LightLevelHUD.useOldRenderMethod()) {
            LightLevelHUD.drawStringRender(player2, manager);
        } else {
            LightLevelHUD.textureRender(player2, manager);
        }
        OpenGlState.pop(glState);
    }

    private static void drawStringRender(EntityPlayer player2, RenderManager manager) {
        boolean thirdPerson = manager.field_78733_k.field_74320_O == 2;
        EnumFacing playerFacing = player2.func_174811_aO();
        if (thirdPerson) {
            playerFacing = playerFacing.func_176734_d();
        }
        if (playerFacing == EnumFacing.SOUTH || playerFacing == EnumFacing.NORTH) {
            playerFacing = playerFacing.func_176734_d();
        }
        float rotationAngle = playerFacing.func_176734_d().func_185119_l();
        for (int i = 0; i < nextCoord; ++i) {
            LightCoord coord = lightLevels.get(i);
            double x = (double)coord.x - manager.field_78730_l;
            double y = coord.y - manager.field_78731_m;
            double z = (double)coord.z - manager.field_78728_n;
            String text = String.valueOf(coord.lightLevel);
            int margin = -(font.func_78256_a(text) + 1) / 2;
            double scale = 0.08;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
            GlStateManager.func_179114_b((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.05, (double)5.0E-4, (double)0.3);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)-0.08, (double)-0.08, (double)0.08);
            GlStateManager.func_179109_b((float)0.3f, (float)0.3f, (float)0.0f);
            font.func_175065_a(text, (float)margin, 0.0f, Color.BLACK.rgbWithAlpha(0.99f), false);
            GlStateManager.func_179109_b((float)-0.3f, (float)-0.3f, (float)-0.001f);
            font.func_175065_a(text, (float)margin, 0.0f, coord.color.rgbWithAlpha(0.99f), false);
            GlStateManager.func_179121_F();
        }
    }

    private static void textureRender(EntityPlayer player2, RenderManager manager) {
        boolean isThirdPerson = manager.field_78733_k.field_74320_O == 2;
        EnumFacing playerFacing = player2.func_174811_aO();
        if (isThirdPerson) {
            playerFacing = playerFacing.func_176734_d();
        }
        float rotationAngle = playerFacing.func_176734_d().func_185119_l();
        sheet.bindTexture();
        VertexBuffer renderer = Tessellator.func_178181_a().func_178180_c();
        for (int i = 0; i < nextCoord; ++i) {
            LightCoord coord = lightLevels.get(i);
            double x = (double)coord.x - manager.field_78730_l;
            double y = coord.y - manager.field_78731_m;
            double z = (double)coord.z - manager.field_78728_n;
            Vec2f U = sheet.getMinMaxU(coord.lightLevel);
            Vec2f V = sheet.getMinMaxV(coord.lightLevel);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
            GlStateManager.func_179114_b((float)(-rotationAngle), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)5.0E-4, (double)-0.5);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float red = coord.color.red;
            float green = coord.color.green;
            float blue = coord.color.blue;
            float alpha = 1.0f;
            renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            renderer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)U.field_189982_i, (double)V.field_189982_i).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            renderer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)U.field_189983_j, (double)V.field_189982_i).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            renderer.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)U.field_189983_j, (double)V.field_189983_j).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)U.field_189982_i, (double)V.field_189983_j).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    private static boolean useOldRenderMethod() {
        return !OpenGlUtil.areFrameBuffersSafe();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void resourceReloadEvent(ReloadEvent.Resources event) {
        if (LightLevelHUD.useOldRenderMethod()) {
            DSurround.log().info("Either OptiFine is installed or Framebuffers are disabled", new Object[0]);
            DSurround.log().info("Using drawString method for light level HUD render", new Object[0]);
            if (sheet != null) {
                sheet.release();
                sheet = null;
            }
        } else {
            DSurround.log().info("Using cached texture method for light level HUD render", new Object[0]);
            if (sheet == null) {
                sheet = new LightLevelTextureSheet();
            }
            sheet.updateTexture();
        }
    }

    static {
        showHUD = false;
        lightLevels = new ObjectArray(2048);
        mutable = new BlockPos.MutableBlockPos();
        nextCoord = 0;
        for (int i = 0; i < 2048; ++i) {
            lightLevels.add(new LightCoord());
        }
        frustum = new Frustum();
    }

    private static final class LightCoord {
        public int x;
        public double y;
        public int z;
        public int lightLevel;
        public Color color;

        private LightCoord() {
        }
    }

    private static enum ColorSet {
        BRIGHT(Color.MC_GREEN, Color.MC_YELLOW, Color.MC_RED, Color.MC_DARKAQUA),
        DARK(Color.MC_DARKGREEN, Color.MC_GOLD, Color.MC_DARKRED, Color.MC_DARKBLUE);

        public static final float ALPHA = 1.0f;
        public final Color safe;
        public final Color caution;
        public final Color hazard;
        public final Color noSpawn;

        private ColorSet(@Nonnull Color safe, @Nonnull Color caution, Color hazard, Color noSpawn) {
            this.safe = safe;
            this.caution = caution;
            this.hazard = hazard;
            this.noSpawn = noSpawn;
        }

        public static ColorSet getStyle(int v) {
            if (v >= ColorSet.values().length) {
                return BRIGHT;
            }
            return ColorSet.values()[v];
        }
    }

    public static enum Mode {
        BLOCK,
        BLOCK_SKY;


        public static Mode cycle(Mode mode) {
            int next = mode.ordinal() + 1;
            if (next >= Mode.values().length) {
                next = 0;
            }
            return Mode.values()[next];
        }

        @Nonnull
        public static Mode getMode(int v) {
            if (v >= Mode.values().length) {
                return BLOCK;
            }
            return Mode.values()[v];
        }
    }
}

