/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.hud;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.implem.BlockMap;
import org.blockartistry.DynSurround.client.fx.BlockEffect;
import org.blockartistry.DynSurround.client.handlers.EffectManager;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.FxHandler;
import org.blockartistry.DynSurround.client.hud.GuiOverlay;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.BlockInfo;
import org.blockartistry.lib.ItemStackUtil;
import org.blockartistry.lib.MCHelper;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.gui.Panel;
import org.blockartistry.lib.gui.TextPanel;

@SideOnly(value=Side.CLIENT)
public class InspectionHUD
extends GuiOverlay {
    private static final String TEXT_FOOTSTEP_ACOUSTICS = TextFormatting.DARK_PURPLE + "<Footstep Accoustics>";
    private static final String TEXT_BLOCK_EFFECTS = TextFormatting.DARK_PURPLE + "<Block Effects>";
    private static final String TEXT_ALWAYS_ON_EFFECTS = TextFormatting.DARK_PURPLE + "<Always On Effects>";
    private static final String TEXT_STEP_SOUNDS = TextFormatting.DARK_PURPLE + "<Step Sounds>";
    private static final String TEXT_BLOCK_SOUNDS = TextFormatting.DARK_PURPLE + "<Block Sounds>";
    private static final String TEXT_DICTIONARY_NAMES = TextFormatting.DARK_PURPLE + "<Dictionary Names>";
    private final BlockInfo.BlockInfoMutable block = new BlockInfo.BlockInfoMutable();
    private final TextPanel textPanel = new TextPanel();

    private static List<String> gatherOreNames(ItemStack stack) {
        ArrayList<String> result = new ArrayList<String>();
        if (ItemStackUtil.isValidItemStack(stack)) {
            for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                result.add(OreDictionary.getOreName((int)i));
            }
        }
        return result;
    }

    private static String getItemName(ItemStack stack) {
        Item item = stack.func_77973_b();
        String itemName = MCHelper.nameOf(item);
        if (itemName != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(itemName);
            if (stack.func_77981_g()) {
                builder.append(':').append(stack.func_77952_i());
            }
            return builder.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> gatherBlockText(ItemStack stack, List<String> text, IBlockState state, BlockPos pos) {
        List<String> oreNames;
        if (ItemStackUtil.isValidItemStack(stack)) {
            text.add(TextFormatting.RED + stack.func_82833_r());
            String itemName = InspectionHUD.getItemName(stack);
            if (itemName != null) {
                text.add("ITEM: " + itemName);
                text.add(TextFormatting.DARK_AQUA + stack.func_77973_b().getClass().getName());
            }
        }
        if (state != null) {
            SoundEffect s;
            int n;
            SoundEffect[] sounds;
            BlockEffect[] effects2;
            BlockMap bm;
            this.block.set(state);
            text.add("BLOCK: " + this.block.toString());
            text.add(TextFormatting.DARK_AQUA + this.block.getBlock().getClass().getName());
            text.add("Material: " + MCHelper.getMaterialName(state.func_185904_a()));
            SoundType st = state.func_177230_c().getSoundType(state, EnvironStateHandler.EnvironState.getWorld(), pos, (Entity)EnvironStateHandler.EnvironState.getPlayer());
            if (st != null) {
                text.add("Step Sound: " + st.func_185844_d().func_187503_a().toString());
            }
            if (ClientRegistry.FOOTSTEPS.hasFootprint(state)) {
                text.add("Footprints Generated");
            }
            if ((bm = ClientRegistry.FOOTSTEPS.getBlockMap()) != null) {
                ArrayList<String> data = new ArrayList<String>();
                bm.collectData(EnvironStateHandler.EnvironState.getWorld(), state, pos, data);
                if (data.size() > 0) {
                    text.add(TEXT_FOOTSTEP_ACOUSTICS);
                    for (String s2 : data) {
                        text.add(TextFormatting.GOLD + s2);
                    }
                }
            }
            if ((effects2 = ClientRegistry.BLOCK.getEffects(state)).length > 0) {
                text.add(TEXT_BLOCK_EFFECTS);
                for (BlockEffect blockEffect : effects2) {
                    text.add(TextFormatting.GOLD + blockEffect.getEffectType().getName());
                }
            }
            if ((effects2 = ClientRegistry.BLOCK.getAlwaysOnEffects(state)).length > 0) {
                text.add(TEXT_ALWAYS_ON_EFFECTS);
                for (BlockEffect blockEffect : effects2) {
                    text.add(TextFormatting.GOLD + blockEffect.getEffectType().getName());
                }
            }
            if ((sounds = ClientRegistry.BLOCK.getAllStepSounds(state)).length > 0) {
                void var11_19;
                text.add(TEXT_STEP_SOUNDS);
                text.add(TextFormatting.DARK_GREEN + "Chance: 1 in " + ClientRegistry.BLOCK.getStepSoundChance(state));
                SoundEffect[] soundEffectArray = sounds;
                n = soundEffectArray.length;
                boolean bl = false;
                while (var11_19 < n) {
                    s = soundEffectArray[var11_19];
                    text.add(TextFormatting.GOLD + s.toString());
                    ++var11_19;
                }
            }
            if ((sounds = ClientRegistry.BLOCK.getAllSounds(state)).length > 0) {
                void var11_21;
                text.add(TEXT_BLOCK_SOUNDS);
                text.add(TextFormatting.DARK_GREEN + "Chance: 1 in " + ClientRegistry.BLOCK.getSoundChance(state));
                SoundEffect[] soundEffectArray = sounds;
                n = soundEffectArray.length;
                boolean bl = false;
                while (var11_21 < n) {
                    s = soundEffectArray[var11_21];
                    text.add(TextFormatting.GOLD + s.toString());
                    ++var11_21;
                }
            }
        }
        if ((oreNames = InspectionHUD.gatherOreNames(stack)).size() > 0) {
            text.add(TEXT_DICTIONARY_NAMES);
            for (String ore : oreNames) {
                text.add(TextFormatting.GOLD + ore);
            }
        }
        return text;
    }

    private List<String> gatherEntityText(@Nonnull Entity entity, @Nonnull List<String> text) {
        try {
            String keyName = EntityList.func_75621_b((Entity)entity);
            if (keyName == null) {
                keyName = "No ID Found";
            }
            text.add(TextFormatting.DARK_AQUA + entity.func_70005_c_());
            text.add(keyName);
            text.add(entity.getClass().getName());
            text.add(TextFormatting.GOLD + "Effects");
            text.addAll(((FxHandler)EffectManager.instance().lookupService(FxHandler.class)).getEffects(entity));
        }
        catch (Exception ex) {
            text.add(TextFormatting.RED + "!! ERROR !!");
        }
        return text;
    }

    private static boolean isHolding() {
        ItemStack held = EnvironStateHandler.EnvironState.getPlayer().func_184586_b(EnumHand.MAIN_HAND);
        return held != null && held.func_77973_b() == Items.field_151146_bM;
    }

    @Override
    public void doTick(int tickRef) {
        if (tickRef != 0 && tickRef % 5 == 0) {
            this.textPanel.resetText();
            if (ModOptions.logging.enableDebugLogging && InspectionHUD.isHolding()) {
                ArrayList<String> data = new ArrayList<String>();
                RayTraceResult current = Minecraft.func_71410_x().field_71476_x;
                if (current != null) {
                    if (current.field_72308_g != null) {
                        this.gatherEntityText(current.field_72308_g, data);
                    } else {
                        BlockPos targetBlock = current == null || current.func_178782_a() == null ? BlockPos.field_177992_a : current.func_178782_a();
                        IBlockState state = WorldUtils.getBlockState(EnvironStateHandler.EnvironState.getWorld(), targetBlock);
                        if (!WorldUtils.isAirBlock(state)) {
                            ItemStack stack = state != null ? state.func_177230_c().getPickBlock(state, current, EnvironStateHandler.EnvironState.getWorld(), targetBlock, EnvironStateHandler.EnvironState.getPlayer()) : null;
                            this.gatherBlockText(stack, data, state, targetBlock);
                        }
                    }
                }
                if (data.size() > 0) {
                    this.textPanel.setText(data);
                }
            }
        }
    }

    @Override
    public void doRender(@Nonnull RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && this.textPanel.hasText()) {
            int centerX = event.getResolution().func_78326_a() / 2;
            int centerY = 80;
            this.textPanel.render(centerX, 80, Panel.Reference.TOP_CENTER);
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(@Nonnull ItemTooltipEvent event) {
        ItemStack stack;
        if (ModOptions.logging.enableDebugLogging && (stack = event.getItemStack()) != null) {
            String itemName = InspectionHUD.getItemName(stack);
            event.getToolTip().add(TextFormatting.GOLD + itemName);
            event.getToolTip().add(TextFormatting.GOLD + stack.func_77973_b().getClass().getName());
        }
    }
}

