/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.trace;

import gnu.trove.map.hash.TObjectIntHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.lib.ThreadGuard;

@SideOnly(value=Side.CLIENT)
public class TraceParticleManager
extends ParticleManager {
    protected final ParticleManager manager;
    protected TObjectIntHashMap<Class<?>> counts = new TObjectIntHashMap();
    protected final ThreadGuard guard = new ThreadGuard(DSurround.log(), Side.CLIENT, "ParticleManager").setAction(DSurround.isDeveloperMode() ? ThreadGuard.Action.EXCEPTION : (ModOptions.logging.enableDebugLogging ? ThreadGuard.Action.LOG : ThreadGuard.Action.NONE));

    public TraceParticleManager(@Nonnull ParticleManager manager) {
        super(null, null);
        this.manager = manager;
    }

    private void checkForClientThread(String method) {
        this.guard.check(method);
    }

    public TObjectIntHashMap<Class<?>> getSnaptshot() {
        TObjectIntHashMap<Class<?>> result = this.counts;
        this.counts = new TObjectIntHashMap();
        return result;
    }

    public void func_178926_a(Entity entityIn, EnumParticleTypes particleTypes) {
        this.checkForClientThread("emitParticleAtEntity");
        this.manager.func_178926_a(entityIn, particleTypes);
    }

    public Particle func_178927_a(int particleId, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.checkForClientThread("spawnEffectParticle");
        return this.manager.func_178927_a(particleId, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_78873_a(Particle effect) {
        this.checkForClientThread("addEffect");
        if (effect != null) {
            this.counts.adjustOrPutValue(effect.getClass(), 1, 1);
        }
        this.manager.func_78873_a(effect);
    }

    public void func_78868_a() {
        this.checkForClientThread("updateEffects");
        this.manager.func_78868_a();
    }

    public void func_78874_a(Entity entityIn, float partialTicks) {
        this.checkForClientThread("renderParticles");
        this.manager.func_78874_a(entityIn, partialTicks);
    }

    public void func_78872_b(Entity entityIn, float partialTick) {
        this.checkForClientThread("renderLitParticles");
        this.manager.func_78872_b(entityIn, partialTick);
    }

    public void func_78870_a(@Nullable World worldIn) {
        this.checkForClientThread("clearEffects");
        this.manager.func_78870_a(worldIn);
    }

    public void func_180533_a(BlockPos pos, IBlockState state) {
        this.checkForClientThread("addBlockDestroyEffects");
        this.manager.func_180533_a(pos, state);
    }

    public void func_180532_a(BlockPos pos, EnumFacing side) {
        this.checkForClientThread("addBlockHitEffects");
        this.manager.func_180532_a(pos, side);
    }

    public void addBlockHitEffects(BlockPos pos, RayTraceResult target) {
        this.checkForClientThread("addBlockHitEffects");
        this.manager.addBlockHitEffects(pos, target);
    }

    public String func_78869_b() {
        this.checkForClientThread("getStatistics");
        return this.manager.func_78869_b();
    }
}

