/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.scanners;

import gnu.trove.map.custom_hash.TObjectIntCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientChunkCache;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public final class BiomeScanner
implements ITickable {
    private static final int BIOME_SURVEY_RANGE = 20;
    private static final int MAX_BIOME_AREA = (int)Math.pow(41.0, 2.0);
    private int biomeArea;
    private final TObjectIntCustomHashMap<BiomeInfo> weights = new TObjectIntCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
    private final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
    private BiomeInfo surveyedBiome = null;
    private int surveyedDimension = 0;
    private BlockPos surveyedPosition = BlockPos.field_177992_a;

    public void func_73660_a() {
        BlockPos position = EnvironStateHandler.EnvironState.getPlayerPosition();
        if (this.surveyedBiome != EnvironStateHandler.EnvironState.getPlayerBiome() || this.surveyedDimension != EnvironStateHandler.EnvironState.getDimensionId() || this.surveyedPosition.compareTo((Vec3i)position) != 0) {
            this.surveyedBiome = EnvironStateHandler.EnvironState.getPlayerBiome();
            this.surveyedDimension = EnvironStateHandler.EnvironState.getDimensionId();
            this.surveyedPosition = position;
            this.biomeArea = 0;
            this.weights.clear();
            if (EnvironStateHandler.EnvironState.getPlayerBiome().isFake()) {
                this.biomeArea = 1;
                this.weights.put((Object)EnvironStateHandler.EnvironState.getPlayerBiome(), 1);
            } else {
                IBlockAccessEx provider = ClientChunkCache.INSTANCE;
                TObjectIntCustomHashMap scratch = new TObjectIntCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
                for (int dX = -20; dX <= 20; ++dX) {
                    for (int dZ = -20; dZ <= 20; ++dZ) {
                        this.mutable.func_181079_c(this.surveyedPosition.func_177958_n() + dX, 0, this.surveyedPosition.func_177952_p() + dZ);
                        scratch.adjustOrPutValue((Object)provider.func_180494_b((BlockPos)this.mutable), 1, 1);
                    }
                }
                this.biomeArea = MAX_BIOME_AREA;
                scratch.forEachEntry((biome, w) -> {
                    this.weights.put((Object)ClientRegistry.BIOME.get((Biome)biome), w);
                    return true;
                });
            }
        }
    }

    public int getBiomeArea() {
        return this.biomeArea;
    }

    public TObjectIntCustomHashMap<BiomeInfo> getBiomes() {
        return this.weights;
    }
}

