/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.scanners;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.fx.BlockEffect;
import org.blockartistry.DynSurround.registry.BlockProfile;
import org.blockartistry.lib.chunk.IBlockAccessEx;
import org.blockartistry.lib.scanner.CuboidScanner;
import org.blockartistry.lib.scanner.ScanLocus;

@SideOnly(value=Side.CLIENT)
public class AlwaysOnBlockEffectScanner
extends CuboidScanner {
    protected BlockProfile profile = null;
    protected IBlockState lastState = null;

    public AlwaysOnBlockEffectScanner(@Nonnull ScanLocus locus, int range) {
        super(locus, "AlwaysOnBlockEffectScanner", range, 0);
        this.setLogger(DSurround.log());
    }

    @Override
    protected boolean interestingBlock(IBlockState state) {
        if (state == Blocks.field_150350_a.func_176223_P()) {
            return false;
        }
        if (this.lastState != state) {
            this.lastState = state;
            this.profile = ClientRegistry.BLOCK.findProfile(state);
        }
        return this.profile.hasAlwaysOnEffects();
    }

    @Override
    public void blockScan(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        IBlockAccessEx provider = this.locus.getWorld();
        BlockEffect[] effects2 = this.profile.getAlwaysOnEffects();
        for (int i = 0; i < effects2.length; ++i) {
            BlockEffect be = effects2[i];
            if (!be.canTrigger(provider, state, pos, rand)) continue;
            be.doEffect(provider, state, pos, rand);
        }
    }
}

