/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.fog.FogResult;
import org.blockartistry.DynSurround.client.handlers.fog.VanillaFogRangeCalculator;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class MorningFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final float START = 0.63f;
    protected static final float MID = 0.73f;
    protected static final float END = 0.83f;
    protected static final float RESERVE = 10.0f;
    protected int fogDay = -1;
    protected boolean doFog = false;
    protected final FogResult cache = new FogResult();

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        float ca;
        this.cache.set(event);
        if (this.doFog && this.cache.getStart() > 10.0f && EnvironStateHandler.EnvironState.getDimensionId() != 1 && EnvironStateHandler.EnvironState.getDimensionId() != -1 && (ca = EnvironStateHandler.EnvironState.getWorld().func_72826_c((float)event.getRenderPartialTicks())) >= 0.63f && ca <= 0.83f) {
            float factor = 1.0f - MathStuff.abs(ca - 0.73f) / 0.100000024f;
            float shift = this.cache.getStart() * factor;
            float newEnd = this.cache.getEnd() - shift;
            float newStart = MathStuff.clamp(this.cache.getStart() - shift * 2.0f, 11.0f, newEnd);
            this.cache.set(newStart, newEnd);
        }
        return this.cache;
    }

    @Override
    public void tick() {
        int day = EnvironStateHandler.EnvironState.getClock().getDay();
        if (this.fogDay != day) {
            this.fogDay = day;
            this.doFog = ModOptions.fog.morningFogChance < 2 || XorShiftRandom.current().nextInt(ModOptions.fog.morningFogChance) == 0;
        }
    }
}

