/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.fog;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.handlers.fog.FogResult;
import org.blockartistry.DynSurround.client.handlers.fog.IFogRangeCalculator;

@SideOnly(value=Side.CLIENT)
public class HolisticFogRangeCalculator
implements IFogRangeCalculator {
    protected final List<IFogRangeCalculator> calculators = new ArrayList<IFogRangeCalculator>();
    protected final FogResult cached = new FogResult();

    public void add(@Nonnull IFogRangeCalculator calc2) {
        this.calculators.add(calc2);
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        float start = event.getFarPlaneDistance();
        float end = event.getFarPlaneDistance();
        for (IFogRangeCalculator calc2 : this.calculators) {
            FogResult result = calc2.calculate(event);
            start = Math.min(start, result.getStart());
            end = Math.min(end, result.getEnd());
        }
        this.cached.set(start, end);
        return this.cached;
    }

    @Override
    public void tick() {
        for (IFogRangeCalculator calc2 : this.calculators) {
            calc2.tick();
        }
    }

    @Nonnull
    public String toString() {
        return this.cached.toString();
    }
}

