/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.fog;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.handlers.fog.IFogColorCalculator;
import org.blockartistry.lib.Color;

@SideOnly(value=Side.CLIENT)
public class HolisticFogColorCalculator
implements IFogColorCalculator {
    protected List<IFogColorCalculator> calculators = new ArrayList<IFogColorCalculator>();
    protected Color cached;

    public void add(@Nonnull IFogColorCalculator calc2) {
        this.calculators.add(calc2);
    }

    @Override
    public Color calculate(@Nonnull EntityViewRenderEvent.FogColors event) {
        Color result = null;
        for (IFogColorCalculator calc2 : this.calculators) {
            Color color = calc2.calculate(event);
            if (result == null) {
                result = color;
                continue;
            }
            if (color == null) continue;
            result = result.mix(color);
        }
        this.cached = result;
        return this.cached;
    }

    @Override
    public void tick() {
        for (IFogColorCalculator calc2 : this.calculators) {
            calc2.tick();
        }
    }

    public String toString() {
        return this.cached != null ? this.cached.toString() : "<NOT SET>";
    }
}

