/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientChunkCache;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.fog.VanillaFogColorCalculator;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.chunk.IBlockAccessEx;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class BiomeFogColorCalculator
extends VanillaFogColorCalculator {
    protected int posX;
    protected int posZ;
    protected double weightBiomeFog;
    protected Color biomeFogColor;
    protected boolean doScan = true;

    @Override
    @Nonnull
    public Color calculate(@Nonnull EntityViewRenderEvent.FogColors event) {
        float thunderStrength;
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        World world = EnvironStateHandler.EnvironState.getWorld();
        IBlockAccessEx provider = ClientChunkCache.INSTANCE;
        int playerX = MathStuff.floor(player2.field_70165_t);
        int playerZ = MathStuff.floor(player2.field_70161_v);
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 6;
        if (settings.field_74347_j && ranges.length > 0) {
            distance = ranges[MathStuff.clamp(settings.field_151451_c, 0, ranges.length - 1)];
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        this.doScan |= this.posX != playerX || this.posZ != playerZ;
        if (this.doScan) {
            this.doScan = false;
            this.posX = playerX;
            this.posZ = playerZ;
            this.biomeFogColor = new Color(0, 0, 0);
            this.weightBiomeFog = 0.0;
            for (int x = -distance; x <= distance; ++x) {
                for (int z = -distance; z <= distance; ++z) {
                    pos.func_181079_c(playerX + x, 0, playerZ + z);
                    this.doScan |= !provider.isAvailable((BlockPos)pos);
                    BiomeInfo biome = ClientRegistry.BIOME.get(provider.func_180494_b((BlockPos)pos));
                    Color color = biome.getHasDust() ? biome.getDustColor() : (biome.getHasFog() ? biome.getFogColor() : null);
                    if (color == null) continue;
                    this.biomeFogColor.add(color);
                    this.weightBiomeFog += 1.0;
                }
            }
        }
        if (this.weightBiomeFog == 0.0 || distance == 0) {
            return super.calculate(event);
        }
        float partialTicks = (float)event.getRenderPartialTicks();
        float celestialAngle = world.func_72826_c(partialTicks);
        float baseScale = MathStuff.clamp(MathStuff.cos(celestialAngle * (float)Math.PI * 2.0f) * 2.0f + 0.5f, 0.0f, 1.0f);
        double rScale = baseScale * 0.94f + 0.06f;
        double gScale = baseScale * 0.94f + 0.06f;
        double bScale = baseScale * 0.91f + 0.09f;
        float rainStrength = Weather.getIntensityLevel();
        if (rainStrength > 0.0f) {
            rScale *= (double)(1.0f - rainStrength * 0.5f);
            gScale *= (double)(1.0f - rainStrength * 0.5f);
            bScale *= (double)(1.0f - rainStrength * 0.4f);
        }
        if ((thunderStrength = Weather.getThunderStrength()) > 0.0f) {
            rScale *= (double)(1.0f - thunderStrength * 0.5f);
            gScale *= (double)(1.0f - thunderStrength * 0.5f);
            bScale *= (double)(1.0f - thunderStrength * 0.5f);
        }
        Color fogColor = new Color(this.biomeFogColor);
        fogColor.scale((float)(rScale / this.weightBiomeFog), (float)(gScale / this.weightBiomeFog), (float)(bScale / this.weightBiomeFog));
        Color processedColor = this.applyPlayerEffects(world, (EntityLivingBase)player2, fogColor, partialTicks);
        double weightMixed = (distance * 2 + 1) * (distance * 2 + 1);
        double weightDefault = weightMixed - this.weightBiomeFog;
        Color vanillaColor = super.calculate(event);
        processedColor.scale((float)this.weightBiomeFog);
        vanillaColor.scale((float)weightDefault);
        return processedColor.add(vanillaColor).scale((float)(1.0 / weightMixed));
    }

    protected Color applyPlayerEffects(@Nonnull World world, @Nonnull EntityLivingBase player2, @Nonnull Color fogColor, float renderPartialTicks) {
        int duration;
        float darkScale = (float)((player2.field_70137_T + (player2.field_70163_u - player2.field_70137_T) * (double)renderPartialTicks) * world.field_73011_w.func_76565_k());
        if (player2.func_70644_a(MobEffects.field_76440_q)) {
            duration = player2.func_70660_b(MobEffects.field_76440_q).func_76459_b();
            darkScale *= duration < 20 ? 1.0f - (float)duration / 20.0f : 0.0f;
        }
        if (darkScale < 1.0f) {
            darkScale = darkScale < 0.0f ? 0.0f : darkScale * darkScale;
            fogColor.scale(darkScale);
        }
        if (player2.func_70644_a(MobEffects.field_76439_r)) {
            duration = player2.func_70660_b(MobEffects.field_76439_r).func_76459_b();
            float brightness = duration > 200 ? 1.0f : 0.7f + MathStuff.sin(((float)duration - renderPartialTicks) * (float)Math.PI * 0.2f) * 0.3f;
            float scale = 1.0f / fogColor.red;
            scale = Math.min(scale, 1.0f / fogColor.green);
            scale = Math.min(scale, 1.0f / fogColor.blue);
            return fogColor.scale(1.0f - brightness + scale * brightness);
        }
        return fogColor;
    }
}

