/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.ItemStackUtil;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.effects.IEntityEffectHandlerState;
import org.blockartistry.lib.sound.ITrackedSound;

@SideOnly(value=Side.CLIENT)
public class PlayerToolBarSoundEffect
extends EntityEffect {
    protected final MainHandTracker mainHand;
    protected final HandTracker offHand;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = (e, eei) -> eei.effects.contains("toolbar");

    public PlayerToolBarSoundEffect(@Nonnull EntityPlayer player2) {
        this.mainHand = new MainHandTracker(player2);
        this.offHand = new HandTracker(player2);
    }

    @Override
    public String name() {
        return "Toolbar";
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (ModOptions.sound.enableEquipSound) {
            this.mainHand.update(this.getState());
            this.offHand.update(this.getState());
        }
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new PlayerToolBarSoundEffect((EntityPlayer)entity));
        }
    }

    protected static class MainHandTracker
    extends HandTracker {
        protected int lastSlot = -1;

        public MainHandTracker(@Nonnull EntityPlayer player2) {
            super(player2, EnumHand.MAIN_HAND);
            this.lastSlot = player2.field_71071_by.field_70461_c;
        }

        @Override
        protected boolean triggerNewEquipSound(@Nonnull EntityPlayer player2) {
            return this.lastSlot != player2.field_71071_by.field_70461_c || super.triggerNewEquipSound(player2);
        }

        @Override
        public void update(@Nonnull IEntityEffectHandlerState state) {
            super.update(state);
            this.lastSlot = ((EntityPlayer)state.subject().get()).field_71071_by.field_70461_c;
        }
    }

    protected static class HandTracker {
        protected final EnumHand hand;
        protected Item lastHeld = null;

        public HandTracker(@Nonnull EntityPlayer player2) {
            this(player2, EnumHand.OFF_HAND);
        }

        protected HandTracker(@Nonnull EntityPlayer player2, @Nonnull EnumHand hand) {
            this.hand = hand;
            this.lastHeld = this.getItemForHand(player2, hand);
        }

        protected Item getItemForHand(EntityPlayer player2, EnumHand hand) {
            ItemStack stack = player2.func_184586_b(hand);
            return ItemStackUtil.isValidItemStack(stack) ? stack.func_77973_b() : null;
        }

        protected boolean triggerNewEquipSound(@Nonnull EntityPlayer player2) {
            Item heldItem = this.getItemForHand(player2, this.hand);
            return heldItem != this.lastHeld;
        }

        protected void clearState(@Nonnull IEntityEffectHandlerState state) {
            this.lastHeld = null;
        }

        public void update(@Nonnull IEntityEffectHandlerState state) {
            EntityPlayer player2 = (EntityPlayer)state.subject().get();
            if (this.triggerNewEquipSound(player2)) {
                this.clearState(state);
                ItemStack currentStack = player2.func_184586_b(this.hand);
                SoundEffect soundEffect = ClientRegistry.ITEMS.getEquipSound(currentStack);
                if (soundEffect != null) {
                    ITrackedSound snd = state.createSound(soundEffect, (Entity)player2);
                    state.playSound(snd);
                    this.lastHeld = currentStack.func_77973_b();
                }
            }
        }
    }
}

