/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.system.Generator;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.effects.IEntityEffectHandlerState;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class EntityFootprintEffect
extends EntityEffect {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected Generator generator;
    protected int lastStyle;
    protected boolean eventRegistered;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = (e, eei) -> eei.effects.contains("footprint");

    @Override
    public String name() {
        return "Footstep/Prints";
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectHandlerState state) {
        super.intitialize(state);
        EntityLivingBase entity = (EntityLivingBase)this.getState().subject().get();
        this.generator = ClientRegistry.FOOTSTEPS.createGenerator(entity);
        this.lastStyle = ModOptions.player.footprintStyle;
        if (entity instanceof EntityPlayerSP) {
            this.eventRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void update(@Nonnull Entity subject) {
        EntityLivingBase entity = (EntityLivingBase)subject;
        if (this.getState().isActivePlayer((Entity)entity) && this.lastStyle != ModOptions.player.footprintStyle) {
            this.generator = ClientRegistry.FOOTSTEPS.createGenerator(entity);
            this.lastStyle = ModOptions.player.footprintStyle;
        }
        this.generator.generateFootsteps(entity);
    }

    @Override
    public void die() {
        if (this.eventRegistered) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void diagnostic(@Nonnull DiagnosticEvent.Gather event) {
        event.output.add("Footsteps: " + this.generator.toString());
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.generator.getPedometer();
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntityFootprintEffect());
        }
    }
}

