/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.event.SpeechTextEvent;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.Translations;
import org.blockartistry.lib.WeightTable;
import org.blockartistry.lib.compat.EntityUtil;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class EntityChatEffect
extends EntityEffect {
    private static final Map<String, EntityChatData> messages = new HashMap<String, EntityChatData>();
    protected final Random random = XorShiftRandom.current();
    protected final EntityChatData data;
    protected long nextChat;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER;

    static void setTimers(@Nonnull Class<? extends Entity> entity, int base, int random) {
        EntityChatEffect.setTimers(EntityUtil.getClassName(entity), base, random);
    }

    static void setTimers(@Nonnull String entity, int base, int random) {
        EntityChatData data = messages.get(entity);
        if (data != null) {
            data.baseInterval = base;
            data.baseRandom = random;
        }
    }

    static boolean hasMessages(@Nonnull Entity entity) {
        return !(entity instanceof EntityPlayer) && messages.get(EntityUtil.getClassName(entity.getClass())) != null;
    }

    public EntityChatEffect(@Nonnull Entity entity) {
        this(entity, null);
    }

    public EntityChatEffect(@Nonnull Entity entity, @Nullable String entityName) {
        String theName = StringUtils.isEmpty((CharSequence)entityName) ? EntityUtil.getClassName(entity.getClass()) : entityName;
        this.data = messages.get(theName);
        this.nextChat = this.getWorldTicks(entity) + (long)this.getNextChatTime();
    }

    @Override
    public String name() {
        return "Entity Chat";
    }

    protected int getBase() {
        return this.data.baseInterval;
    }

    protected int getRandom() {
        return this.data.baseRandom;
    }

    protected long getWorldTicks(Entity e) {
        return e.func_130014_f_().func_82737_E();
    }

    protected String getChatMessage() {
        return this.data.table.next();
    }

    protected int getNextChatTime() {
        return this.getBase() + this.random.nextInt(this.getRandom());
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.speechbubbles.enableEntityChat) {
            return;
        }
        long ticks = this.getWorldTicks(subject);
        long delta = this.nextChat - ticks;
        if (delta <= 0L) {
            SpeechTextEvent event = new SpeechTextEvent(subject.func_145782_y(), this.getChatMessage(), true);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.genNextChatTime();
        }
    }

    public void genNextChatTime() {
        this.nextChat = this.getWorldTicks(this.getState().subject().get()) + (long)this.getNextChatTime();
    }

    static {
        Translations xlate = new Translations();
        xlate.load("/assets/dsurround/dsurround/data/chat/", "en_US");
        xlate.forAll(new WeightTableBuilder());
        EntityChatEffect.setTimers(EntitySquid.class, 600, 1200);
        DEFAULT_FILTER = (e, eei) -> eei.effects.contains("chat") && !(e instanceof EntityVillager) && EntityChatEffect.hasMessages(e);
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntityChatEffect(entity));
        }
    }

    private static class WeightTableBuilder
    implements Predicate<Map.Entry<String, String>> {
        private final Pattern TYPE_PATTERN = Pattern.compile("chat\\.([a-zA-Z.]*)\\.[0-9]*$");
        private final Pattern WEIGHT_PATTERN = Pattern.compile("^([0-9]*),(.*)");

        public boolean apply(@Nonnull Map.Entry<String, String> input) {
            Matcher matcher1 = this.TYPE_PATTERN.matcher(input.getKey());
            if (matcher1.matches()) {
                String key = matcher1.group(1).toLowerCase();
                Matcher matcher2 = this.WEIGHT_PATTERN.matcher(input.getValue());
                if (matcher2.matches()) {
                    EntityChatData data = (EntityChatData)messages.get(key);
                    if (data == null) {
                        data = new EntityChatData();
                        messages.put(key, data);
                    }
                    final int weight = Integer.parseInt(matcher2.group(1));
                    final String item = matcher2.group(2);
                    data.table.add(new WeightTable.IItem<String>(){

                        @Override
                        public int getWeight() {
                            return weight;
                        }

                        @Override
                        public String getItem() {
                            return item;
                        }
                    });
                } else {
                    DSurround.log().warn("Invalid value in language file: %s", input.getValue());
                }
            } else {
                DSurround.log().warn("Invalid key in language file: %s", input.getKey());
            }
            return true;
        }
    }

    static class EntityChatData {
        public static final int DEFAULT_INTERVAL = 400;
        public static final int DEFAULT_RANDOM = 1200;
        public int baseInterval = 400;
        public int baseRandom = 1200;
        public final WeightTable<String> table = new WeightTable();

        EntityChatData() {
        }
    }
}

