/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.bubbles;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.ParticleBillboard;
import org.blockartistry.DynSurround.client.handlers.bubbles.SpeechBubbleData;
import org.blockartistry.lib.gfx.ParticleHelper;

@SideOnly(value=Side.CLIENT)
public class EntityBubbleContext
implements Supplier<List<String>> {
    private final List<SpeechBubbleData> data = new ArrayList<SpeechBubbleData>();
    private List<String> preppedList;
    private ParticleBillboard bubble;

    public void add(@Nonnull SpeechBubbleData d) {
        this.data.add(d);
        this.preppedList = null;
    }

    public boolean clean(int currentTick) {
        boolean reset = false;
        Iterator<SpeechBubbleData> itr = this.data.iterator();
        while (itr.hasNext()) {
            SpeechBubbleData d = itr.next();
            if (!d.isExpired(currentTick)) continue;
            itr.remove();
            reset = true;
        }
        if (reset) {
            this.preppedList = null;
        }
        return this.data.isEmpty();
    }

    public void handleBubble(@Nonnull Entity entity) {
        if (this.bubble == null || this.bubble.shouldExpire()) {
            this.bubble = new ParticleBillboard(entity, this);
            ParticleHelper.addParticle(this.bubble);
        }
    }

    public List<String> get() {
        if (this.preppedList == null && this.data.size() > 0) {
            this.preppedList = new ArrayList<String>();
            for (SpeechBubbleData entry : this.data) {
                this.preppedList.addAll(entry.getText());
            }
        }
        return this.preppedList;
    }
}

