/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.sound.BasicSound;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.DynSurround.event.ThunderEvent;

@SideOnly(value=Side.CLIENT)
public class WeatherHandler
extends EffectHandlerBase {
    private int timer = 0;

    public WeatherHandler() {
        super("Weather");
    }

    @Override
    public boolean doTick(int tick) {
        return this.timer > 0;
    }

    @Override
    public void onConnect() {
        this.timer = 0;
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        --this.timer;
        player2.func_130014_f_().func_175702_c(2);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onThunderEvent(@Nonnull ThunderEvent event) {
        if (!ModOptions.rain.allowBackgroundThunder || EnvironStateHandler.EnvironState.getDimensionId() != event.dimId) {
            return;
        }
        Object thunder = Sounds.THUNDER.createSoundAt(event.location).setVolume(ModOptions.sound.thunderVolume);
        SoundEffectHandler.INSTANCE.playSound((BasicSound<?>)thunder);
        if (event.doFlash) {
            this.timer = 2;
        }
    }

    @SubscribeEvent
    public void diagnostic(@Nonnull DiagnosticEvent.Gather event) {
        event.output.add(Weather.diagnostic());
    }
}

