/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import com.google.common.base.Function;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.bubbles.EntityBubbleContext;
import org.blockartistry.DynSurround.client.handlers.bubbles.SpeechBubbleData;
import org.blockartistry.DynSurround.event.SpeechTextEvent;
import org.blockartistry.lib.Translations;
import org.blockartistry.lib.WorldUtils;

@SideOnly(value=Side.CLIENT)
public class SpeechBubbleHandler
extends EffectHandlerBase {
    private static final String SPLASH_TOKEN = "$MINECRAFT$";
    private static final ResourceLocation SPLASH_TEXT = new ResourceLocation("texts/splashes.txt");
    private final TIntObjectHashMap<EntityBubbleContext> messages = new TIntObjectHashMap();
    private final Translations xlate = new Translations();
    private final List<String> minecraftSplashText = new ArrayList<String>();

    private void loadText() {
        String[] langs = Minecraft.func_71410_x().field_71474_y.field_74363_ab.equals("en_US") ? new String[]{"en_US"} : new String[]{"en_US", Minecraft.func_71410_x().field_71474_y.field_74363_ab};
        this.xlate.load("/assets/dsurround/dsurround/data/chat/", langs);
        this.xlate.transform(new Stripper());
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXT);){
            String s;
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(resource.func_110527_b(), Charsets.UTF_8));
            while ((s = bufferedreader.readLine()) != null) {
                if ((s = s.trim()).isEmpty()) continue;
                this.minecraftSplashText.add(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SpeechBubbleHandler() {
        super("Speech Bubbles");
        this.loadText();
    }

    private void addSpeechBubbleFormatted(@Nonnull Entity entity, @Nonnull String message, Object ... parms) {
        String xlated = this.xlate.format(message, parms);
        if (this.minecraftSplashText.size() > 0 && SPLASH_TOKEN.equals(xlated)) {
            xlated = this.minecraftSplashText.get(this.RANDOM.nextInt(this.minecraftSplashText.size()));
        }
        this.addSpeechBubble(entity, xlated);
    }

    private void addSpeechBubble(@Nonnull Entity entity, @Nonnull String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return;
        }
        EntityBubbleContext ctx = (EntityBubbleContext)this.messages.get(entity.func_145782_y());
        if (ctx == null) {
            ctx = new EntityBubbleContext();
            this.messages.put(entity.func_145782_y(), (Object)ctx);
        }
        int expiry = EnvironStateHandler.EnvironState.getTickCounter() + (int)(ModOptions.speechbubbles.speechBubbleDuration * 20.0f);
        ctx.add(new SpeechBubbleData(message, expiry));
        ctx.handleBubble(entity);
    }

    @Override
    public boolean doTick(int tick) {
        return this.messages.size() > 0;
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        int currentTick = EnvironStateHandler.EnvironState.getTickCounter();
        this.messages.retainEntries((idx, ctx) -> !ctx.clean(currentTick));
    }

    @Override
    public void onConnect() {
        this.messages.clear();
    }

    @Override
    public void onDisconnect() {
        this.messages.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onSpeechTextEvent(@Nonnull SpeechTextEvent event) {
        Entity entity = WorldUtils.locateEntity(EnvironStateHandler.EnvironState.getWorld(), event.entityId);
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityPlayer && !ModOptions.speechbubbles.enableSpeechBubbles) {
            return;
        }
        if (!ModOptions.speechbubbles.enableEntityChat) {
            return;
        }
        if (event.translate) {
            this.addSpeechBubbleFormatted(entity, event.message, new Object[0]);
        } else {
            this.addSpeechBubble(entity, event.message);
        }
    }

    private static class Stripper
    implements Function<Map.Entry<String, String>, String> {
        private final Pattern WEIGHT_PATTERN = Pattern.compile("^([0-9]*),(.*)");

        private Stripper() {
        }

        public String apply(@Nonnull Map.Entry<String, String> input) {
            Matcher matcher = this.WEIGHT_PATTERN.matcher(input.getValue());
            return matcher.matches() ? matcher.group(2) : input.getValue();
        }
    }
}

