/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import com.google.common.collect.Sets;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.gui.ConfigSound;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.sound.AdhocSound;
import org.blockartistry.DynSurround.client.sound.BasicSound;
import org.blockartistry.DynSurround.client.sound.Emitter;
import org.blockartistry.DynSurround.client.sound.EntityEmitter;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.client.sound.SoundEngine;
import org.blockartistry.DynSurround.client.sound.SoundLoader;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.DynSurround.event.PlayDistributedSoundEvent;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.DynSurround.network.Network;
import org.blockartistry.DynSurround.network.PacketPlaySound;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.compat.PositionedSoundUtil;
import org.blockartistry.lib.sound.SoundState;

@SideOnly(value=Side.CLIENT)
public class SoundEffectHandler
extends EffectHandlerBase {
    private static final int AGE_THRESHOLD_TICKS = 10;
    public static final SoundEffectHandler INSTANCE = new SoundEffectHandler();
    private static final Predicate<PendingSound> PENDING_SOUNDS = input -> {
        if (input.getTickAge() >= 10) {
            input.getSound().setState(SoundState.ERROR);
            return true;
        }
        if (input.getTickAge() >= 0) {
            return INSTANCE.playSound(input.getSound()) != null;
        }
        return false;
    };
    private final THashMap<SoundEffect, Emitter> emitters = new THashMap();
    private final THashMap<String, SoundEvent> replacements = new THashMap();
    private final ObjectArray<PendingSound> pending = new ObjectArray();
    private final ObjectArray<BasicSound<?>> sendToServer = new ObjectArray();
    private final Set<String> soundsToBlock = Sets.newHashSet();
    private final TObjectIntHashMap<String> soundCull = new TObjectIntHashMap();

    private SoundEffectHandler() {
        super("Sound Effects");
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        this.emitters.values().forEach(Emitter::update);
        this.pending.removeIf(PENDING_SOUNDS);
        this.sendToServer.forEach(sound2 -> Network.sendToServer(new PacketPlaySound((Entity)player2, (BasicSound<?>)sound2)));
        this.sendToServer.clear();
        this.doMoodProcessing();
    }

    @Override
    public void onConnect() {
        this.clearSounds();
        this.soundsToBlock.clear();
        this.soundCull.clear();
        this.replacements.clear();
        Set reg = SoundEngine.instance().getSoundRegistry().func_148742_b();
        reg.forEach(resource -> {
            String rs = resource.toString();
            if (ClientRegistry.SOUND.isSoundBlockedLogical(rs)) {
                this.soundsToBlock.add(rs);
            } else if (ClientRegistry.SOUND.isSoundCulled(rs)) {
                this.soundCull.put((Object)rs, -ModOptions.sound.soundCullingThreshold);
            }
        });
        ResourceLocation bowLooseResource = new ResourceLocation("dsurround", "bow.loose");
        SoundEvent bowLoose = SoundLoader.getSound(bowLooseResource);
        if (!this.soundsToBlock.contains(bowLooseResource.toString())) {
            this.replacements.put((Object)"minecraft:entity.arrow.shoot", (Object)bowLoose);
            this.replacements.put((Object)"minecraft:entity.skeleton.shoot", (Object)bowLoose);
        }
    }

    @Override
    public void onDisconnect() {
        this.clearSounds();
    }

    public void clearSounds() {
        this.emitters.values().forEach(Emitter::stop);
        this.emitters.clear();
        this.pending.clear();
        SoundEngine.instance().stopAllSounds();
    }

    public void queueAmbientSounds(@Nonnull TObjectFloatHashMap<SoundEffect> sounds) {
        this.emitters.retainEntries((fx, emitter) -> {
            if (emitter.isDonePlaying()) {
                return false;
            }
            float volume = sounds.get(fx);
            if (volume >= 0.0f) {
                emitter.setVolumeThrottle(volume);
                if (emitter.isFading()) {
                    emitter.unfade();
                }
                sounds.remove(fx);
            } else if (!emitter.isFading()) {
                emitter.fade();
            }
            return true;
        });
        sounds.forEachEntry((fx, volume) -> {
            this.emitters.put(fx, (Object)new EntityEmitter((EntityLivingBase)EnvironStateHandler.EnvironState.getPlayer(), (SoundEffect)fx));
            return true;
        });
    }

    public boolean isSoundPlaying(@Nonnull BasicSound<?> sound2) {
        return SoundEngine.instance().isSoundPlaying(sound2);
    }

    public void stopSound(@Nonnull BasicSound<?> sound2) {
        SoundEngine.instance().stopSound(sound2);
    }

    @Nullable
    public String playSound(@Nonnull BasicSound<?> sound2) {
        if (sound2 == null || !sound2.canSoundBeHeard(EnvironStateHandler.EnvironState.getPlayerPosition())) {
            return null;
        }
        if (sound2.shouldRoute() && DSurround.routePacketToServer()) {
            this.sendToServer.add(sound2);
        }
        return SoundEngine.instance().playSound(sound2);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void soundPlay(@Nonnull PlaySoundEvent e) {
        SoundEvent rep;
        String thunderSound;
        int lastOccurance;
        String soundName;
        ISound theSound = e.getSound();
        if (theSound == null || theSound instanceof ConfigSound) {
            return;
        }
        String string = soundName = theSound.func_147650_b() != null ? theSound.func_147650_b().toString() : null;
        if (soundName == null) {
            return;
        }
        if (this.soundsToBlock.contains(soundName)) {
            e.setResultSound(null);
            return;
        }
        if (ModOptions.sound.soundCullingThreshold > 0 && (lastOccurance = this.soundCull.get((Object)soundName)) != 0) {
            int currentTick = EnvironStateHandler.EnvironState.getTickCounter();
            if (currentTick - lastOccurance < ModOptions.sound.soundCullingThreshold) {
                e.setResultSound(null);
                return;
            }
            this.soundCull.put((Object)soundName, currentTick);
        }
        if (e.getName().equals("entity.lightning.thunder") && !this.soundsToBlock.contains(thunderSound = Sounds.THUNDER.getSoundName())) {
            PositionedSound sound2 = (PositionedSound)theSound;
            if (sound2 != null && PositionedSoundUtil.getVolume(sound2) > 16.0f) {
                BlockPos pos = new BlockPos((double)sound2.func_147649_g(), (double)sound2.func_147654_h(), (double)sound2.func_147651_i());
                Object newSound = Sounds.THUNDER.createSoundAt(pos).setVolume(ModOptions.sound.thunderVolume);
                e.setResultSound(newSound);
            }
            return;
        }
        if (theSound instanceof PositionedSound && (rep = (SoundEvent)this.replacements.get((Object)soundName)) != null) {
            e.setResultSound((ISound)new AdhocSound(rep, (PositionedSound)theSound));
        }
    }

    @Nullable
    public String playSoundAtPlayer(@Nullable EntityPlayer player2, @Nonnull SoundEffect sound2) {
        if (player2 == null) {
            player2 = EnvironStateHandler.EnvironState.getPlayer();
        }
        BasicSound<?> s = sound2.createSoundNear((Entity)player2);
        return this.playSound(s);
    }

    @Nullable
    public String playSoundAt(@Nonnull BlockPos pos, @Nonnull SoundEffect sound2, int tickDelay) {
        BasicSound<?> s = sound2.createSoundAt(pos);
        if (tickDelay == 0) {
            return this.playSound(s);
        }
        s.setState(SoundState.DELAYED);
        this.pending.add(new PendingSound(s, tickDelay));
        return null;
    }

    @SubscribeEvent
    public void onDistributedSound(@Nonnull PlayDistributedSoundEvent event) {
        try {
            String soundResource = event.nbt.func_74779_i("s");
            if (!StringUtils.isEmpty((CharSequence)soundResource) && "dsurround:crafting".equals(soundResource)) {
                this.playSound(new AdhocSound(event.nbt));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void registryReloadEvent(@Nonnull ReloadEvent.Registry event) {
        if (event.side == Side.CLIENT) {
            this.onConnect();
        }
    }

    @SubscribeEvent
    public void playerJoinWorldEvent(@Nonnull EntityJoinWorldEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K && EnvironStateHandler.EnvironState.isPlayer(event.getEntity()) && !event.getEntity().field_70128_L) {
            this.clearSounds();
        }
    }

    public void doMoodProcessing() {
        BlockPos blockpos;
        IBlockState iblockstate;
        int deltaZ;
        int deltaY;
        int deltaX;
        int distance;
        WorldClient wc = (WorldClient)EnvironStateHandler.EnvironState.getWorld();
        if (wc.field_184158_M == 1 && (distance = (deltaX = this.RANDOM.nextInt(30) - 15) * deltaX + (deltaY = this.RANDOM.nextInt(30) - 15) * deltaY + (deltaZ = this.RANDOM.nextInt(30) - 15) * deltaZ) > 4 && distance <= 255 && (iblockstate = wc.func_180495_p(blockpos = EnvironStateHandler.EnvironState.getPlayerPosition().func_177982_a(deltaX, deltaY, deltaZ))).func_185904_a() == Material.field_151579_a && wc.func_175642_b(EnumSkyBlock.SKY, blockpos) <= 0 && wc.func_175699_k(blockpos) <= this.RANDOM.nextInt(8)) {
            Object fx = ((BasicSound)Sounds.AMBIENT_CAVE.createSoundAt(blockpos).setVolume(0.9f)).setPitch(0.8f + this.RANDOM.nextFloat() * 0.2f);
            this.playSound((BasicSound<?>)fx);
            wc.field_184158_M = this.RANDOM.nextInt(12000) + 6000;
            DSurround.log().debug("Next ambient event: %d ticks", wc.field_184158_M);
        }
        if (wc.field_184158_M == 1) {
            wc.field_184158_M = 2;
        }
    }

    @SubscribeEvent
    public void diagnostics(@Nonnull DiagnosticEvent.Gather event) {
        event.output.add(String.format("Ambiance Timer: %d", ((WorldClient)EnvironStateHandler.EnvironState.getWorld()).field_184158_M));
        this.emitters.values().forEach(emitter -> event.output.add("EMITTER: " + emitter.toString()));
        this.pending.forEach(effect -> event.output.add((effect.getTickAge() < 0 ? "DELAYED: " : "PENDING: ") + effect.getSound().toString()));
    }

    private static final class PendingSound {
        private final int timeMark;
        private final BasicSound<?> sound;

        public PendingSound(@Nonnull BasicSound<?> sound2, int delay) {
            this.timeMark = EnvironStateHandler.EnvironState.getTickCounter() + delay;
            this.sound = sound2;
        }

        public int getTickAge() {
            return EnvironStateHandler.EnvironState.getTickCounter() - this.timeMark;
        }

        public BasicSound<?> getSound() {
            return this.sound;
        }
    }
}

