/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import gnu.trove.map.hash.TLongObjectHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.particle.system.ParticleSystem;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.lib.BlockPosHelper;

@SideOnly(value=Side.CLIENT)
public class ParticleSystemHandler
extends EffectHandlerBase {
    private final TLongObjectHashMap<ParticleSystem> systems = new TLongObjectHashMap();

    public ParticleSystemHandler() {
        super("Particle Systems");
    }

    @Override
    public boolean doTick(int tick) {
        return !this.systems.isEmpty();
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        double range = ModOptions.general.specialEffectRange;
        BlockPos min = EnvironStateHandler.EnvironState.getPlayerPosition().func_177963_a(-range, -range, -range);
        BlockPos max = EnvironStateHandler.EnvironState.getPlayerPosition().func_177963_a(range, range, range);
        this.systems.retainEntries((idx, system) -> {
            if (BlockPosHelper.notContains(system.getPos(), min, max)) {
                system.setExpired();
            } else {
                system.onUpdate();
            }
            return system.isAlive();
        });
    }

    @Override
    public void onConnect() {
        this.systems.clear();
    }

    @Override
    public void onDisconnect() {
        this.systems.clear();
    }

    public boolean okToSpawn(@Nonnull BlockPos pos) {
        return !this.systems.containsKey(pos.func_177986_g());
    }

    public void addSystem(@Nonnull ParticleSystem system) {
        this.systems.put(system.getPos().func_177986_g(), (Object)system);
    }
}

