/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.ParticleCollections;
import org.blockartistry.DynSurround.client.fx.particle.mote.IParticleMote;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.entity.CapabilityEmojiData;
import org.blockartistry.DynSurround.entity.EmojiType;
import org.blockartistry.DynSurround.entity.IEmojiDataSettable;
import org.blockartistry.DynSurround.event.EntityEmojiEvent;
import org.blockartistry.lib.WorldUtils;

@SideOnly(value=Side.CLIENT)
public class EntityEmojiHandler
extends EffectHandlerBase {
    private final TIntObjectHashMap<IParticleMote> emojiParticles = new TIntObjectHashMap();

    public EntityEmojiHandler() {
        super("Entity Emojis");
    }

    @Override
    public boolean doTick(int tick) {
        return this.emojiParticles.size() > 0;
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        this.emojiParticles.retainEntries((idx, emoji) -> emoji.isAlive());
    }

    @SubscribeEvent
    public void onEntityEmojiEvent(@Nonnull EntityEmojiEvent event) {
        Entity entity = WorldUtils.locateEntity(EnvironStateHandler.EnvironState.getWorld(), event.entityId);
        if (entity != null) {
            IParticleMote mote;
            IEmojiDataSettable data = (IEmojiDataSettable)entity.getCapability(CapabilityEmojiData.EMOJI, null);
            data.setActionState(event.actionState);
            data.setEmotionalState(event.emotionalState);
            data.setEmojiType(event.emojiType);
            if (ModOptions.speechbubbles.enableEntityEmojis && entity.func_70089_S() && data.getEmojiType() != EmojiType.NONE && !this.emojiParticles.contains(event.entityId) && (mote = ParticleCollections.addEmoji(entity)) != null) {
                this.emojiParticles.put(event.entityId, (Object)mote);
            }
        }
    }

    @Override
    public void onConnect() {
        this.emojiParticles.clear();
    }

    @Override
    public void onDisconnect() {
        this.emojiParticles.clear();
    }
}

