/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.AreaBlockEffectsHandler;
import org.blockartistry.DynSurround.client.handlers.AuroraEffectHandler;
import org.blockartistry.DynSurround.client.handlers.BiomeSoundEffectsHandler;
import org.blockartistry.DynSurround.client.handlers.DiagnosticHandler;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EntityEmojiHandler;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.EnvironmentEffectHandler;
import org.blockartistry.DynSurround.client.handlers.FxHandler;
import org.blockartistry.DynSurround.client.handlers.ParticleSystemHandler;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.handlers.SpeechBubbleHandler;
import org.blockartistry.DynSurround.client.handlers.WeatherHandler;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.compat.EntityLivingBaseUtil;
import org.blockartistry.lib.math.TimerEMA;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class EffectManager {
    private static final EffectManager instance_ = new EffectManager();
    private static boolean isConnected = false;
    private final ObjectArray<EffectHandlerBase> effectHandlers = new ObjectArray();
    private final Map<Class<? extends EffectHandlerBase>, EffectHandlerBase> services = new IdentityHashMap<Class<? extends EffectHandlerBase>, EffectHandlerBase>();
    private final TimerEMA computeTime = new TimerEMA("Processing");

    public static EffectManager instance() {
        return instance_;
    }

    private EffectManager() {
        this.init();
    }

    private void register(@Nonnull EffectHandlerBase handler) {
        this.effectHandlers.add(handler);
        this.services.put(handler.getClass(), handler);
        DSurround.log().debug("Registered handler [%s]", handler.getClass().getName());
    }

    private void init() {
        this.register(new EnvironStateHandler());
        this.register(new AreaBlockEffectsHandler());
        this.register(new EnvironmentEffectHandler());
        this.register(new ParticleSystemHandler());
        this.register(new BiomeSoundEffectsHandler());
        this.register(new EntityEmojiHandler());
        this.register(new AuroraEffectHandler());
        this.register(new SpeechBubbleHandler());
        this.register(new WeatherHandler());
        this.register(new FxHandler());
        this.register(SoundEffectHandler.INSTANCE);
        this.register(new DiagnosticHandler());
    }

    private void onConnect() {
        for (EffectHandlerBase h : this.effectHandlers) {
            h.connect0();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((DiagnosticHandler)this.lookupService(DiagnosticHandler.class)).addTimer(this.computeTime);
    }

    private void onDisconnect() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (EffectHandlerBase h : this.effectHandlers) {
            h.disconnect0();
        }
    }

    public <T> T lookupService(@Nonnull Class<? extends EffectHandlerBase> service) {
        EffectHandlerBase eh = this.services.get(service);
        if (eh == null) {
            DSurround.log().warn("Unable to locate handler service [%s]", service.getName());
        }
        return (T)eh;
    }

    public boolean isConnected() {
        return isConnected;
    }

    public static void connect() {
        if (isConnected) {
            DSurround.log().warn("Attempt to initialize EffectManager when it is already initialized", new Object[0]);
            EffectManager.disconnect();
        }
        instance_.onConnect();
        isConnected = true;
    }

    public static void disconnect() {
        if (isConnected) {
            instance_.onDisconnect();
            isConnected = false;
        }
    }

    protected static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    protected boolean checkReady(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y == null) {
            return false;
        }
        if (Minecraft.func_71410_x().func_175598_ae().field_78733_k == null) {
            return false;
        }
        EntityPlayer player2 = EffectManager.getPlayer();
        return player2 != null && player2.func_130014_f_() != null;
    }

    public void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (!this.checkReady(event)) {
            return;
        }
        long start = System.nanoTime();
        if (ModOptions.player.suppressPotionParticles) {
            EffectManager.getPlayer().func_184212_Q().func_187227_b(EntityLivingBaseUtil.getHideParticles(), (Object)true);
        }
        int tick = EnvironStateHandler.EnvironState.getTickCounter();
        for (int i = 0; i < this.effectHandlers.size(); ++i) {
            EffectHandlerBase handler = this.effectHandlers.get(i);
            long mark = System.nanoTime();
            if (handler.doTick(tick)) {
                handler.process(EffectManager.getPlayer());
            }
            handler.updateTimer(System.nanoTime() - mark);
        }
        this.computeTime.update(System.nanoTime() - start);
    }

    @SubscribeEvent
    public static void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (isConnected) {
            instance_.onTick(event);
        }
    }
}

