/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.gui.ConfigSound;
import org.blockartistry.DynSurround.client.gui.GuiConstants;
import org.blockartistry.DynSurround.client.sound.BasicSound;
import org.blockartistry.DynSurround.client.sound.MusicTickerReplacement;
import org.blockartistry.DynSurround.client.sound.SoundEngine;

@SideOnly(value=Side.CLIENT)
public class PlaySoundButton
extends GuiButtonExt {
    private final String soundResource;
    private BasicSound<?> playingSound;

    public PlaySoundButton(int id, @Nonnull String sound2) {
        super(id, 0, 0, 68, 18, GuiConstants.TEXT_PLAY);
        this.soundResource = sound2;
    }

    public String getSoundResource() {
        return this.soundResource;
    }

    protected void updateDisplayText() {
        this.field_146126_j = this.playingSound != null ? GuiConstants.TEXT_STOP : GuiConstants.TEXT_PLAY;
    }

    public void func_146112_a(@Nonnull Minecraft mc, int x, int y) {
        super.func_146112_a(mc, x, y);
        if (this.playingSound != null && !SoundEngine.instance().isSoundPlaying(this.playingSound)) {
            this.playingSound = null;
            this.updateDisplayText();
        }
    }

    private void doPlay(@Nonnull ConfigSound sound2) {
        MusicTicker ticker = Minecraft.func_71410_x().func_181535_r();
        this.playingSound = sound2;
        if (ticker instanceof MusicTickerReplacement) {
            MusicTickerReplacement mtr = (MusicTickerReplacement)ticker;
            mtr.setPlaying(sound2);
        } else {
            SoundEngine.instance().playSound(sound2);
        }
    }

    public void playSound(@Nonnull Minecraft mc, float volume) {
        if (this.playingSound != null) {
            SoundEngine.instance().stopSound(this.playingSound);
            this.playingSound = null;
        } else {
            SoundEngine.instance().stopAllSounds();
            this.doPlay(new ConfigSound(this.soundResource, volume));
        }
        this.updateDisplayText();
    }

    public void stopSound() {
        if (this.playingSound != null) {
            this.playSound(null, 0.0f);
        }
    }
}

