/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.Permissions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.gui.SoundConfigEntry;
import org.blockartistry.DynSurround.client.sound.SoundEngine;
import org.blockartistry.DynSurround.registry.SoundRegistry;
import org.blockartistry.lib.ConfigProcessor;
import org.blockartistry.lib.gui.GuiConfigBase;

@SideOnly(value=Side.CLIENT)
public class DynSurroundConfigGui
extends GuiConfigBase {
    private final Configuration config = DSurround.config();
    private final ConfigElement soundElement;
    private final ConfigCategory soundCategory;

    public DynSurroundConfigGui(GuiScreen parentScreen) {
        super(parentScreen, new ArrayList<IConfigElement>(), "dsurround", false, false, "Dynamic Surroundings");
        this.titleLine2 = this.config.getConfigFile().getAbsolutePath();
        this.addConfigElement(ModOptions.aurora.PATH, "Enabled");
        this.addConfigElement(ModOptions.rain.PATH, "Enable Background Thunder");
        this.addConfigElement(ModOptions.fog.PATH, "Desert Fog");
        this.addConfigElement(ModOptions.fog.PATH, "Elevation Haze");
        this.addConfigElement(ModOptions.fog.PATH, "Biomes Fog");
        this.addConfigElement(ModOptions.sound.PATH, "Enable Biomes Sounds");
        this.addConfigElement(ModOptions.sound.PATH, "Jump Sound");
        this.addConfigElement(ModOptions.sound.PATH, "Equip Sound");
        this.addConfigElement(ModOptions.sound.PATH, "Crafting Sound");
        this.addConfigElement(ModOptions.sound.PATH, "Armor Sound");
        this.addConfigElement(ModOptions.player.PATH, "Footprints");
        this.addConfigElement(ModOptions.player.potionHUD.PATH, "Enable");
        this.addConfigElement(ModOptions.speechbubbles.PATH, "Enable SpeechBubbles");
        this.addConfigElement(ModOptions.speechbubbles.PATH, "Enable Entity Emojis");
        this.addConfigElement(ModOptions.speechbubbles.PATH, "Enable Entity Chat");
        this.addConfigElement(ModOptions.explosions.PATH, "Enable Explosion Enhancement");
        if (Permissions.instance().allowCompassAndClockHUD()) {
            this.addConfigElement(ModOptions.compass.PATH, "Enable Compass");
            this.addConfigElement(ModOptions.compass.PATH, "Enable Clock");
        }
        this.soundCategory = new ConfigCategory("Individual Sound Configuration").setLanguageKey("dsurround.cfg.sound.SoundConfig");
        this.soundElement = new ConfigElement(this.soundCategory);
        this.generateSoundList(this.soundCategory);
        this.configElements.add(this.soundElement);
        this.addConfigCategory(ModOptions.general.PATH);
        this.addConfigCategory(ModOptions.player.PATH);
        if (Permissions.instance().allowCompassAndClockHUD()) {
            this.addConfigCategory(ModOptions.compass.PATH);
        }
        this.addConfigCategory(ModOptions.explosions.PATH);
        this.addConfigCategory(ModOptions.rain.PATH);
        this.addConfigCategory(ModOptions.fog.PATH);
        this.addConfigCategory(ModOptions.aurora.PATH);
        this.addConfigCategory(ModOptions.block.PATH);
        this.addConfigCategory(ModOptions.biomes.PATH);
        this.addConfigCategory(ModOptions.sound.PATH);
        this.addConfigCategory(ModOptions.profiles.PATH);
        if (Permissions.instance().allowLightLevelHUD()) {
            this.addConfigCategory(ModOptions.lightlevel.PATH);
        }
        this.addConfigCategory(ModOptions.speechbubbles.PATH);
        this.addConfigCategory(ModOptions.commands.PATH);
        this.addConfigCategory(ModOptions.asm.PATH);
        this.addConfigCategory(ModOptions.logging.PATH);
    }

    private void addConfigElement(@Nonnull String category, @Nonnull String prop) {
        Property property = this.config.getCategory(category).get(prop);
        this.configElements.add(new ConfigElement(property));
    }

    private void addConfigCategory(@Nonnull String category) {
        ConfigCategory cat = this.config.getCategory(category);
        this.configElements.add(new ConfigElement(cat));
    }

    @Override
    protected void doFixups() {
        this.saveSoundList();
        this.config.save();
        ConfigProcessor.process(this.config, ModOptions.class);
    }

    protected void saveSoundList() {
        ArrayList<String> culledSounds = new ArrayList<String>();
        ArrayList<String> blockedSounds = new ArrayList<String>();
        ArrayList<String> soundVolumes = new ArrayList<String>();
        for (Map.Entry entry : this.soundCategory.entrySet()) {
            int volume;
            String sound2 = (String)entry.getKey();
            String parms = ((Property)entry.getValue()).getString();
            if (StringUtils.isEmpty((CharSequence)parms)) continue;
            if (parms.contains("cull")) {
                parms = parms.replace("cull", "");
                culledSounds.add(sound2);
            }
            if (parms.contains("block")) {
                parms = parms.replace("block", "");
                blockedSounds.add(sound2);
            }
            if (StringUtils.isEmpty((CharSequence)(parms = parms.trim())) || (volume = Integer.parseInt(parms)) == 100) continue;
            soundVolumes.add(sound2 + "=" + volume);
        }
        String[] results = culledSounds.toArray(new String[culledSounds.size()]);
        this.config.getCategory(ModOptions.sound.PATH).get("Culled Sounds").set(results);
        results = blockedSounds.toArray(new String[blockedSounds.size()]);
        this.config.getCategory(ModOptions.sound.PATH).get("Blocked Sounds").set(results);
        results = soundVolumes.toArray(new String[soundVolumes.size()]);
        this.config.getCategory(ModOptions.sound.PATH).get("Sound Volume").set(results);
    }

    protected void generateSoundList(ConfigCategory cat) {
        cat.setRequiresMcRestart(false);
        cat.setRequiresWorldRestart(false);
        ArrayList<String> sounds = new ArrayList<String>();
        for (Object resource : SoundEngine.instance().getSoundRegistry().func_148742_b()) {
            sounds.add(resource.toString());
        }
        Collections.sort(sounds);
        SoundRegistry registry = ClientRegistry.SOUND;
        for (String sound2 : sounds) {
            float v;
            Property prop = new Property(sound2, "", Property.Type.STRING);
            prop.setDefaultValue("");
            prop.setRequiresMcRestart(false);
            prop.setRequiresWorldRestart(false);
            prop.setConfigEntryClass(SoundConfigEntry.class);
            StringBuilder builder = new StringBuilder();
            if (registry.isSoundBlocked(sound2)) {
                builder.append("block").append(' ');
            }
            if (registry.isSoundCulled(sound2)) {
                builder.append("cull").append(' ');
            }
            if ((v = registry.getVolumeScale(sound2)) != 1.0f) {
                builder.append((int)(v * 100.0f));
            }
            prop.setValue(builder.toString());
            cat.put(sound2, prop);
        }
    }
}

