/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.system;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.ParticleCollections;
import org.blockartistry.DynSurround.client.fx.WaterSplashJetEffect;
import org.blockartistry.DynSurround.client.fx.particle.mote.IParticleMote;
import org.blockartistry.DynSurround.client.fx.particle.system.ParticleJet;
import org.blockartistry.DynSurround.client.sound.PositionedEmitter;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class ParticleWaterSplash
extends ParticleJet {
    private static final SoundEffect[] fallSounds = new SoundEffect[11];
    private static final BlockPos.MutableBlockPos pos;
    private final BlockPos location;
    private PositionedEmitter emitter;
    protected int particleLimit;

    public ParticleWaterSplash(int strength, World world, BlockPos loc, double x, double y, double z) {
        super(0, strength, world, x, y, z, 2);
        this.location = loc.func_185334_h();
        this.setSpawnCount((int)((float)strength * 2.5f));
    }

    public void setSpawnCount(int limit) {
        this.particleLimit = MathStuff.clamp(limit, 5, 15);
    }

    public int getSpawnCount() {
        switch (ParticleWaterSplash.SETTINGS.field_74362_aa) {
            case 2: {
                return 0;
            }
            case 0: {
                return this.particleLimit;
            }
        }
        return this.particleLimit / 2;
    }

    @Override
    public boolean shouldDie() {
        return !WaterSplashJetEffect.isValidSpawnBlock(WorldUtils.getDefaultBlockStateProvider(), this.location);
    }

    private boolean setupSound() {
        return this.isAlive() && this.jetStrength > 2 && this.emitter == null && RANDOM.nextInt(6) == 0;
    }

    @Override
    protected void soundUpdate() {
        if (this.setupSound()) {
            pos.func_189532_c(this.posX, this.posY, this.posZ);
            int idx = MathStuff.clamp(this.jetStrength, 0, fallSounds.length - 1);
            this.emitter = new PositionedEmitter(fallSounds[idx], (BlockPos)pos);
            this.emitter.setPitch(1.0f + 0.2f * (RANDOM.nextFloat() - RANDOM.nextFloat()));
        }
        if (this.emitter != null) {
            this.emitter.update();
        }
    }

    @Override
    protected void cleanUp() {
        if (this.emitter != null) {
            this.emitter.stop();
        }
        this.emitter = null;
        super.cleanUp();
    }

    @Override
    protected void spawnJetParticle() {
        if (ParticleCollections.canFitWaterSpray()) {
            int splashCount = this.getSpawnCount();
            int j = 0;
            while ((float)j < (float)splashCount) {
                double zOffset;
                double xOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
                if (!WorldUtils.isSolidBlock(this.world, (BlockPos)pos.func_189532_c(this.posX + xOffset, this.posY, this.posZ + (zOffset = (double)(RANDOM.nextFloat() * 2.0f - 1.0f))))) {
                    double motionX = xOffset * ((double)this.jetStrength / 25.0);
                    double motionZ = zOffset * ((double)this.jetStrength / 25.0);
                    double motionY = 0.1 + (double)(RANDOM.nextFloat() * (float)this.jetStrength) / 20.0;
                    IParticleMote particle = ParticleCollections.addWaterSpray(this.world, this.posX + xOffset, this.posY, this.posZ + zOffset, motionX, motionY, motionZ);
                    if (particle == null) break;
                }
                ++j;
            }
        }
    }

    static {
        ParticleWaterSplash.fallSounds[0] = Sounds.WATERFALL0;
        ParticleWaterSplash.fallSounds[1] = Sounds.WATERFALL0;
        ParticleWaterSplash.fallSounds[2] = Sounds.WATERFALL1;
        ParticleWaterSplash.fallSounds[3] = Sounds.WATERFALL1;
        ParticleWaterSplash.fallSounds[4] = Sounds.WATERFALL2;
        ParticleWaterSplash.fallSounds[5] = Sounds.WATERFALL3;
        ParticleWaterSplash.fallSounds[6] = Sounds.WATERFALL3;
        ParticleWaterSplash.fallSounds[7] = Sounds.WATERFALL4;
        ParticleWaterSplash.fallSounds[8] = Sounds.WATERFALL4;
        ParticleWaterSplash.fallSounds[9] = Sounds.WATERFALL5;
        ParticleWaterSplash.fallSounds[10] = Sounds.WATERFALL5;
        pos = new BlockPos.MutableBlockPos();
    }
}

