/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.system;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.gfx.ParticleHelper;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public abstract class ParticleSystem {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final GameSettings SETTINGS = Minecraft.func_71410_x().field_71474_y;
    protected final World world;
    protected final double posX;
    protected final double posY;
    protected final double posZ;
    protected final BlockPos position;
    private boolean isAlive = true;

    protected ParticleSystem(World worldIn, double posXIn, double posYIn, double posZIn) {
        this.world = worldIn;
        this.posX = posXIn;
        this.posY = posYIn;
        this.posZ = posZIn;
        this.position = new BlockPos(posXIn, posYIn, posZIn);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.position;
    }

    public void addParticle(@Nonnull Particle particle) {
        ParticleHelper.addParticle(particle);
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setExpired() {
        this.isAlive = false;
        this.cleanUp();
    }

    public boolean shouldDie() {
        return false;
    }

    protected void cleanUp() {
    }

    public void onUpdate() {
        if (this.shouldDie()) {
            this.setExpired();
            return;
        }
        this.think();
        if (this.isAlive()) {
            this.soundUpdate();
        }
    }

    protected void soundUpdate() {
    }

    public abstract void think();
}

