/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.mote;

import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientChunkCache;
import org.blockartistry.DynSurround.client.fx.particle.mote.MoteAgeable;

@SideOnly(value=Side.CLIENT)
public abstract class MoteMotionBase
extends MoteAgeable {
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    protected double gravity;
    protected double prevX;
    protected double prevY;
    protected double prevZ;

    protected MoteMotionBase(@Nonnull World world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z);
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        this.motionX = dX;
        this.motionY = dY;
        this.motionZ = dZ;
        this.gravity = 0.06;
    }

    @Override
    protected float renderX(float partialTicks) {
        return (float)(this.prevX + (this.posX - this.prevX) * (double)partialTicks - this.interpX());
    }

    @Override
    protected float renderY(float partialTicks) {
        return (float)(this.prevY + (this.posY - this.prevY) * (double)partialTicks - this.interpY());
    }

    @Override
    protected float renderZ(float partialTicks) {
        return (float)(this.prevZ + (this.posZ - this.prevZ) * (double)partialTicks - this.interpZ());
    }

    protected boolean hasCollided() {
        return ClientChunkCache.INSTANCE.func_180495_p((BlockPos)this.position).func_185904_a().func_76220_a();
    }

    protected void handleCollision() {
        this.kill();
    }

    @Override
    protected void update() {
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        this.motionY -= this.gravity;
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        this.position.func_189532_c(this.posX, this.posY, this.posZ);
        if (this.hasCollided()) {
            this.handleCollision();
        } else {
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
        }
    }
}

